/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.atttributes;

import com.jetbrains.sourceglider.domains.DomainType;
import com.jetbrains.sourceglider.utils.PrettyName;

public class Attribute
implements Comparable {
    private String key;
    private DomainType type;
    private String compUnitPath;
    private int srcPos;
    private int srcLength;
    private PrettyName prettyName;

    public Attribute(String key2, DomainType type2, String compUnitPath, int srcPos, int srcLength, PrettyName prettyName) {
        this.key = key2;
        this.type = type2;
        this.compUnitPath = compUnitPath;
        this.srcPos = srcPos;
        this.srcLength = srcLength;
        this.prettyName = prettyName;
    }

    public String getKey() {
        return this.key;
    }

    public DomainType getType() {
        return this.type;
    }

    public void setType(DomainType type2) {
        this.type = type2;
    }

    public String getCompUnitPath() {
        return this.compUnitPath;
    }

    public int getSrcPos() {
        return this.srcPos;
    }

    public int getSrcLength() {
        return this.srcLength;
    }

    public PrettyName getPrettyName() {
        return this.prettyName;
    }

    public boolean isRevealable() {
        return this.type.isRevealable() && this.compUnitPath != null && this.srcPos != -1;
    }

    public String toString() {
        return this.key + '(' + this.prettyName.getMarked() + ')';
    }

    public int compareTo(Object obj) {
        return this.prettyName.getText().compareTo(((Attribute)obj).prettyName.getText());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Attribute)) {
            return false;
        }
        Attribute attribute = (Attribute)obj;
        return this.key.equals(attribute.key) && this.type == attribute.type;
    }

    public int hashCode() {
        return this.key.hashCode() * 31 + this.type.hashCode();
    }
}

