/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.bdd.javaimpl;

import com.jetbrains.sourceglider.bdd.BDDException;
import com.jetbrains.sourceglider.bdd.IBDD;
import com.jetbrains.sourceglider.bdd.javaimpl.BDDManagerJavaImpl;
import com.jetbrains.sourceglider.ui.Messages;
import com.jetbrains.sourceglider.ui.ThreadCallback;
import com.jetbrains.sourceglider.utils.ArrayHelper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class BDDJavaImpl
implements Serializable,
IBDD {
    private static final long serialVersionUID = 3952043618068176239L;
    int var;
    BDDJavaImpl low;
    BDDJavaImpl high;
    transient int refCount;
    transient boolean mark;
    transient int serialID;
    transient BDDJavaImpl link;
    BDDManagerJavaImpl manager;
    private static final int OP_COMPLEMENT = 1;
    private static final int OP_RENAME = 2;
    private static final int OP_EXISTS = 3;
    private static final int OP_UNITE = 4;
    private static final int OP_INTERSECT = 5;
    private static final int OP_SUPERSET = 6;
    private static final int OP_SIZE = 7;
    private static final int OP_RELPROD = 8;
    private static final int OP_EXISTS_VAR = 9;

    @Override
    public void incRefCount() {
        ++this.refCount;
    }

    @Override
    public void decRefCount() {
        this.manager.decRefCount(this);
    }

    void unMark() {
        if (this.mark && this != this.manager.zero && this != this.manager.one) {
            this.mark = false;
            this.low.unMark();
            this.high.unMark();
        }
    }

    long evaluateReachableNodesCnt() {
        if (this.mark) {
            return 0L;
        }
        this.mark = true;
        return this.low.evaluateReachableNodesCnt() + this.high.evaluateReachableNodesCnt() + 1L;
    }

    static void serialize(ObjectOutputStream out, IBDD[] nodes, ThreadCallback threadCallback, double progressPart, String message2) throws IOException {
        out.writeInt(nodes.length);
        for (int i2 = 0; i2 < nodes.length; ++i2) {
            if (threadCallback != null) {
                if (threadCallback.checkCancelled()) break;
                threadCallback.informProgress(i2, (int)((double)nodes.length / progressPart), message2);
            }
            out.writeObject(nodes[i2]);
        }
    }

    static BDDJavaImpl[] deserialize(ObjectInputStream in, ThreadCallback threadCallback, double progressPart, String message2) throws IOException, ClassNotFoundException {
        int length = in.readInt();
        BDDJavaImpl[] result2 = new BDDJavaImpl[length];
        for (int i2 = 0; i2 < length; ++i2) {
            if (threadCallback != null) {
                if (threadCallback.checkCancelled()) break;
                threadCallback.informProgress(i2, (int)((double)length / progressPart), message2);
            }
            BDDJavaImpl node = (BDDJavaImpl)in.readObject();
            result2[i2] = node.mark ? node.link : node.initAfterDeserialize();
        }
        return result2;
    }

    private BDDJavaImpl initAfterDeserialize() {
        if (this.var == 0x7FFFFFFE) {
            return this.manager.zero;
        }
        if (this.var == Integer.MAX_VALUE) {
            return this.manager.one;
        }
        this.mark = true;
        if (this.low.mark) {
            this.low = this.low.link;
            ++this.low.refCount;
        } else {
            this.low = this.low.initAfterDeserialize();
        }
        if (this.high.mark) {
            this.high = this.high.link;
            ++this.high.refCount;
        } else {
            this.high = this.high.initAfterDeserialize();
        }
        this.link = this.manager.cacheNode(this.var, this.low, this.high);
        return this.link;
    }

    @Override
    public boolean isZero() {
        return this == this.manager.zero;
    }

    @Override
    public boolean isOne() {
        return this == this.manager.one;
    }

    @Override
    public IBDD complement() {
        if (this == this.manager.zero) {
            return this.manager.one;
        }
        if (this == this.manager.one) {
            return this.manager.zero;
        }
        int hashCode = this.manager.opHashCode(1, this, this);
        BDDJavaImpl cached = this.manager.searchInOpCache(1, this, this, hashCode);
        if (cached != null) {
            return cached;
        }
        return this.manager.putInOpCache(1, this, this, this.manager.cacheNode(this.var, (BDDJavaImpl)this.low.complement(), (BDDJavaImpl)this.high.complement()), hashCode);
    }

    private BDDJavaImpl unite(BDDJavaImpl node, ThreadCallback threadCallback) {
        if (threadCallback.checkCancelled()) {
            return this.manager.zero;
        }
        if (this == this.manager.one) {
            return this.manager.one;
        }
        if (node == this.manager.one) {
            return this.manager.one;
        }
        if (this == this.manager.zero) {
            ++node.refCount;
            return node;
        }
        if (node == this.manager.zero || node == this) {
            ++this.refCount;
            return this;
        }
        int hashCode = this.manager.opHashCode(4, this, node);
        BDDJavaImpl cached = this.manager.searchInOpCache(4, this, node, hashCode);
        if (cached != null) {
            return cached;
        }
        BDDJavaImpl result2 = this.var < node.var ? this.manager.cacheNode(this.var, this.low.unite(node, threadCallback), this.high.unite(node, threadCallback)) : (this.var == node.var ? this.manager.cacheNode(this.var, this.low.unite(node.low, threadCallback), this.high.unite(node.high, threadCallback)) : this.manager.cacheNode(node.var, this.unite(node.low, threadCallback), this.unite(node.high, threadCallback)));
        return this.manager.putInOpCache(4, this, node, result2, hashCode);
    }

    @Override
    public IBDD unite(IBDD node, ThreadCallback threadCallback) {
        return this.unite((BDDJavaImpl)node, threadCallback);
    }

    private BDDJavaImpl intersect(BDDJavaImpl node, ThreadCallback threadCallback) {
        if (threadCallback.checkCancelled()) {
            return this.manager.zero;
        }
        if (this == this.manager.zero) {
            return this.manager.zero;
        }
        if (node == this.manager.zero) {
            return this.manager.zero;
        }
        if (this == this.manager.one) {
            ++node.refCount;
            return node;
        }
        if (node == this.manager.one || node == this) {
            ++this.refCount;
            return this;
        }
        int hashCode = this.manager.opHashCode(5, this, node);
        BDDJavaImpl cached = this.manager.searchInOpCache(5, this, node, hashCode);
        if (cached != null) {
            return cached;
        }
        BDDJavaImpl result2 = this.var < node.var ? this.manager.cacheNode(this.var, this.low.intersect(node, threadCallback), this.high.intersect(node, threadCallback)) : (this.var == node.var ? this.manager.cacheNode(this.var, this.low.intersect(node.low, threadCallback), this.high.intersect(node.high, threadCallback)) : this.manager.cacheNode(node.var, this.intersect(node.low, threadCallback), this.intersect(node.high, threadCallback)));
        return this.manager.putInOpCache(5, this, node, result2, hashCode);
    }

    @Override
    public IBDD intersect(IBDD node, ThreadCallback threadCallback) {
        return this.intersect((BDDJavaImpl)node, threadCallback);
    }

    @Override
    public IBDD exists(int delVar, ThreadCallback threadCallback) {
        if (this.var < delVar) {
            int hashCode = this.manager.opHashCode(9, this, delVar);
            BDDJavaImpl cached = this.manager.searchInOpCache(9, this, delVar, hashCode);
            if (cached != null) {
                return cached;
            }
            return this.manager.putInOpCache(9, this, delVar, this.manager.cacheNode(this.var, (BDDJavaImpl)this.low.exists(delVar, threadCallback), (BDDJavaImpl)this.high.exists(delVar, threadCallback)), hashCode);
        }
        if (this.var == delVar) {
            return this.low.unite(this.high, threadCallback);
        }
        ++this.refCount;
        return this;
    }

    @Override
    public IBDD exists(int firstVar, int length, ThreadCallback threadCallback) {
        if (this.var < firstVar + length) {
            IBDD result2;
            int hashCode = this.manager.opHashCode(3, this, firstVar);
            BDDJavaImpl cached = this.manager.searchInOpCache(3, this, firstVar, hashCode);
            if (cached != null) {
                return cached;
            }
            if (this.var < firstVar) {
                result2 = this.manager.cacheNode(this.var, (BDDJavaImpl)this.low.exists(firstVar, length, threadCallback), (BDDJavaImpl)this.high.exists(firstVar, length, threadCallback));
            } else {
                IBDD left = this.low.exists(firstVar, length, threadCallback);
                IBDD right = this.high.exists(firstVar, length, threadCallback);
                result2 = left.unite(right, threadCallback);
                left.decRefCount();
                right.decRefCount();
            }
            return this.manager.putInOpCache(3, this, firstVar, (BDDJavaImpl)result2, hashCode);
        }
        ++this.refCount;
        return this;
    }

    private boolean doTestVars(int firstVar, int length) {
        if (this.mark) {
            return false;
        }
        this.mark = true;
        if (this.var >= firstVar + length) {
            return false;
        }
        if (this.var < firstVar + length && this.var >= firstVar) {
            return true;
        }
        if (this.low.doTestVars(firstVar, length)) {
            return true;
        }
        return this.high.doTestVars(firstVar, length);
    }

    @Override
    public boolean testVars(int firstVar, int length) {
        boolean result2 = this.doTestVars(firstVar, length);
        this.unMark();
        return result2;
    }

    @Override
    public IBDD rename(int firstVar, int length, int varOffset, ThreadCallback threadCallback) {
        if (this == this.manager.zero || this == this.manager.one || this.var >= firstVar + length) {
            ++this.refCount;
            return this;
        }
        int secondOperand = firstVar << 16 | varOffset + 32768;
        int hashCode = this.manager.opHashCode(2, this, secondOperand);
        BDDJavaImpl result2 = this.manager.searchInOpCache(2, this, secondOperand, hashCode);
        if (result2 != null) {
            return result2;
        }
        result2 = this.var < firstVar ? this.manager.cacheNode(this.var, (BDDJavaImpl)this.low.rename(firstVar, length, varOffset, threadCallback), (BDDJavaImpl)this.high.rename(firstVar, length, varOffset, threadCallback)) : this.manager.cacheNode(this.var + varOffset, (BDDJavaImpl)this.low.rename(firstVar, length, varOffset, threadCallback), (BDDJavaImpl)this.high.rename(firstVar, length, varOffset, threadCallback));
        return this.manager.putInOpCache(2, this, secondOperand, result2, hashCode);
    }

    private BDDJavaImpl relprod(BDDJavaImpl node, int firstVar, int length, ThreadCallback threadCallback) {
        BDDJavaImpl result2;
        if (this == this.manager.zero || node == this.manager.zero) {
            return this.manager.zero;
        }
        if (this == this.manager.one && node == this.manager.one) {
            return this.manager.one;
        }
        if (this == this.manager.one) {
            return (BDDJavaImpl)node.exists(firstVar, length, threadCallback);
        }
        if (node == this.manager.one) {
            return (BDDJavaImpl)this.exists(firstVar, length, threadCallback);
        }
        int hashCode = this.manager.opHashCode(8, this, node, firstVar);
        BDDJavaImpl cached = this.manager.searchInOpCache(8, this, node, firstVar, hashCode);
        if (cached != null) {
            return cached;
        }
        if (this.var < node.var) {
            if (this.var >= firstVar && this.var < firstVar + length) {
                BDDJavaImpl left = this.low.unite(this.high, threadCallback);
                result2 = left.relprod(node, firstVar, length, threadCallback);
                left.decRefCount();
            } else {
                result2 = this.manager.cacheNode(this.var, this.low.relprod(node, firstVar, length, threadCallback), this.high.relprod(node, firstVar, length, threadCallback));
            }
        } else if (this.var == node.var) {
            BDDJavaImpl left = this.low.relprod(node.low, firstVar, length, threadCallback);
            BDDJavaImpl right = this.high.relprod(node.high, firstVar, length, threadCallback);
            if (this.var >= firstVar && this.var < firstVar + length) {
                result2 = left.unite(right, threadCallback);
                left.decRefCount();
                right.decRefCount();
            } else {
                result2 = this.manager.cacheNode(this.var, left, right);
            }
        } else if (node.var >= firstVar && node.var < firstVar + length) {
            BDDJavaImpl left = node.low.unite(node.high, threadCallback);
            result2 = left.relprod(this, firstVar, length, threadCallback);
            left.decRefCount();
        } else {
            result2 = this.manager.cacheNode(node.var, node.low.relprod(this, firstVar, length, threadCallback), node.high.relprod(this, firstVar, length, threadCallback));
        }
        return this.manager.putInOpCache(8, this, node, firstVar, result2, hashCode);
    }

    @Override
    public IBDD relprod(IBDD node, int firstVar, int length, ThreadCallback threadCallback) {
        return this.relprod((BDDJavaImpl)node, firstVar, length, threadCallback);
    }

    private boolean superset(BDDJavaImpl node) {
        if (this == this.manager.one) {
            return true;
        }
        if (node == this.manager.zero) {
            return true;
        }
        if (this == node) {
            return true;
        }
        if (this == this.manager.zero) {
            return false;
        }
        if (node == this.manager.one) {
            return false;
        }
        int hashCode = this.manager.opHashCode(6, this, node);
        BDDJavaImpl cached = this.manager.searchInOpCache(6, this, node, hashCode);
        if (cached != null) {
            return cached != this.manager.zero;
        }
        boolean result2 = this.var < node.var ? this.low.superset(node) && this.high.superset(node) : (this.var == node.var ? this.low.superset(node.low) && this.high.superset(node.high) : this.superset(node.low) && this.superset(node.high));
        this.manager.putInOpCache(6, this, node, result2 ? this.manager.one : this.manager.zero, hashCode);
        return result2;
    }

    @Override
    public boolean superset(IBDD node) {
        return this.superset((BDDJavaImpl)node);
    }

    @Override
    public boolean equals(IBDD node) {
        return this == node;
    }

    private BDDJavaImpl addTuple(int[] starts, int[] lengths, int[] values, int index, int curvar) {
        BDDJavaImpl result2;
        boolean outOfDomain;
        if (this == this.manager.one) {
            return this.manager.one;
        }
        boolean bl = outOfDomain = curvar >= starts[index] + lengths[index];
        if (outOfDomain) {
            if (index == starts.length - 1) {
                return this.manager.one;
            }
            ++index;
        }
        if (curvar < starts[index]) {
            curvar = starts[index];
        }
        if (this.var < curvar) {
            result2 = this.manager.cacheNode(this.var, this.low.addTuple(starts, lengths, values, index, curvar), this.high.addTuple(starts, lengths, values, index, curvar));
        } else {
            int position = curvar - starts[index];
            if ((values[index] & 1 << lengths[index] - position - 1) > 0) {
                if (this.var == curvar) {
                    ++this.low.refCount;
                    result2 = this.manager.cacheNode(this.var, this.low, this.high.addTuple(starts, lengths, values, index, curvar + 1));
                } else {
                    ++this.refCount;
                    result2 = this.manager.cacheNode(curvar, this, this.addTuple(starts, lengths, values, index, curvar + 1));
                }
            } else if (this.var == curvar) {
                ++this.high.refCount;
                result2 = this.manager.cacheNode(this.var, this.low.addTuple(starts, lengths, values, index, curvar + 1), this.high);
            } else {
                ++this.refCount;
                result2 = this.manager.cacheNode(curvar, this.addTuple(starts, lengths, values, index, curvar + 1), this);
            }
        }
        return result2;
    }

    @Override
    public IBDD addTuple(int[] starts, int[] lengths, int[] values) {
        return this.addTuple(starts, lengths, values, 0, starts[0]);
    }

    private boolean getNTuples(List vector, int[] starts, int[] lengths, int[] limits, int[] tuple, int index, int curvar, int n) {
        boolean outOfDomain;
        boolean bl = outOfDomain = curvar >= starts[index] + lengths[index];
        if (outOfDomain && index == starts.length - 1) {
            if (this != this.manager.one) {
                throw new BDDException(Messages.getString(BDDJavaImpl.class.getName() + "-11"));
            }
            vector.add(tuple.clone());
            return vector.size() == n;
        }
        if (outOfDomain) {
            ++index;
        }
        if (curvar < starts[index]) {
            curvar = starts[index];
        }
        if (this.var > curvar || this == this.manager.one) {
            int n2 = index;
            tuple[n2] = tuple[n2] << 1;
            if (tuple[index] < limits[index] && this.getNTuples(vector, starts, lengths, limits, tuple, index, curvar + 1, n)) {
                return true;
            }
            int n3 = index;
            tuple[n3] = tuple[n3] + 1;
            if (tuple[index] < limits[index] && this.getNTuples(vector, starts, lengths, limits, tuple, index, curvar + 1, n)) {
                return true;
            }
            int n4 = index;
            tuple[n4] = tuple[n4] >> 1;
        } else if (this.var == curvar) {
            int n5 = index;
            tuple[n5] = tuple[n5] << 1;
            if (this.low != this.manager.zero && tuple[index] < limits[index] && this.low.getNTuples(vector, starts, lengths, limits, tuple, index, curvar + 1, n)) {
                return true;
            }
            if (this.high != this.manager.zero) {
                int n6 = index;
                tuple[n6] = tuple[n6] + 1;
                if (tuple[index] < limits[index] && this.high.getNTuples(vector, starts, lengths, limits, tuple, index, curvar + 1, n)) {
                    return true;
                }
            }
            int n7 = index;
            tuple[n7] = tuple[n7] >> 1;
        } else {
            throw new BDDException(Messages.getString(BDDJavaImpl.class.getName() + "-12"));
        }
        return false;
    }

    @Override
    public int[][] getNTuples(int[] starts, int[] lengths, int[] limits, int n) {
        ArrayList vector = new ArrayList();
        int[] tuple = new int[starts.length];
        if (this != this.manager.zero) {
            this.getNTuples(vector, starts, lengths, limits, tuple, 0, starts[0], n);
        }
        return (int[][])ArrayHelper.castArray(vector.toArray(), int[].class);
    }

    private int getNumOfTuples(int[] starts, int[] lengths, int[] limits, int index, int curvar) {
        boolean outOfDomain;
        boolean bl = outOfDomain = curvar >= starts[index] + lengths[index];
        if (outOfDomain && index == starts.length - 1) {
            if (this == this.manager.one) {
                return 1;
            }
            throw new BDDException(Messages.getString(BDDJavaImpl.class.getName() + "-13"));
        }
        if (outOfDomain) {
            ++index;
        }
        if (curvar < starts[index]) {
            curvar = starts[index];
        }
        if (this.var > curvar || this == this.manager.one) {
            return this.getNumOfTuples(starts, lengths, limits, index, curvar + 1) * 2;
        }
        if (this.var == curvar) {
            int hashCode = this.manager.opHashCode(7, this, this);
            int cached = this.manager.searchInOpCache(7, this, hashCode);
            if (cached != -1) {
                return cached;
            }
            int result2 = 0;
            if (this.low != this.manager.zero) {
                result2 += this.low.getNumOfTuples(starts, lengths, limits, index, curvar + 1);
            }
            if (this.high != this.manager.zero) {
                result2 += this.high.getNumOfTuples(starts, lengths, limits, index, curvar + 1);
            }
            return this.manager.putInOpCache(7, this, result2, hashCode);
        }
        throw new BDDException(Messages.getString(BDDJavaImpl.class.getName() + "-14"));
    }

    @Override
    public int getNumOfTuples(int[] starts, int[] lengths, int[] limits) {
        if (this == this.manager.zero) {
            return 0;
        }
        return this.getNumOfTuples(starts, lengths, limits, 0, starts[0]);
    }

    @Override
    public long getNumOfNodes() {
        long result2 = this.evaluateReachableNodesCnt();
        this.unMark();
        return result2;
    }
}

