/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.bdd.nativeproxy;

import com.jetbrains.sourceglider.ManagerInstancesProvider;
import com.jetbrains.sourceglider.bdd.IBDD;
import com.jetbrains.sourceglider.bdd.IBDDManager;
import com.jetbrains.sourceglider.bdd.nativeproxy.BDDNativeProxy;
import com.jetbrains.sourceglider.ui.IConfigs;
import com.jetbrains.sourceglider.ui.ThreadCallback;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class BDDManagerNativeProxy
implements IBDDManager {
    private static int curSerialID = 0;
    private final ManagerInstancesProvider managerInstancesProvider;
    private int serialID;
    private boolean decRefCountOnGC;

    public BDDManagerNativeProxy(ManagerInstancesProvider provider2) {
        this.managerInstancesProvider = provider2;
    }

    @Override
    public void startInit() {
        IConfigs configs = this.managerInstancesProvider.getUIInstancesProvider().getConfigs();
        String libraryName = configs != null ? configs.getValue("BDDNativeLibrary", "engine-native") : "engine-native";
        this.managerInstancesProvider.loadLibrary(libraryName);
    }

    @Override
    public void init(IConfigs configs) {
        boolean enableGC;
        int garbageCollectRate;
        int maxOpCacheSize;
        int maxNodeCacheSize;
        if (configs != null) {
            maxNodeCacheSize = configs.getIntValue("BDDMaxNodeCacheSize", 10000000);
            maxOpCacheSize = configs.getIntValue("BDDMaxOpCacheSize", 1000000);
            garbageCollectRate = configs.getIntValue("BDDGarbageCollectRate", 0);
            enableGC = configs.getBooleanValue("BDDEnableGC", true);
        } else {
            maxNodeCacheSize = 10000000;
            maxOpCacheSize = 1000000;
            garbageCollectRate = 0;
            enableGC = true;
        }
        this.decRefCountOnGC = garbageCollectRate > 0;
        this.serialID = curSerialID++;
        BDDManagerNativeProxy.doInit(maxNodeCacheSize, maxOpCacheSize, garbageCollectRate, enableGC);
        BDDNativeProxy.zeroIndex = BDDManagerNativeProxy.doGetZero();
        BDDNativeProxy.oneIndex = BDDManagerNativeProxy.doGetOne();
        BDDNativeProxy.zero = new BDDNativeProxy(BDDNativeProxy.zeroIndex);
        BDDNativeProxy.one = new BDDNativeProxy(BDDNativeProxy.oneIndex);
    }

    @Override
    public int getManagerSerialID() {
        return this.serialID;
    }

    @Override
    public String[] getInfo() {
        return BDDManagerNativeProxy.doGetInfo();
    }

    @Override
    public int getMemoryState() {
        return BDDManagerNativeProxy.doGetMemoryState();
    }

    @Override
    public void collectGarbage() {
        BDDManagerNativeProxy.doCollectGarbage();
    }

    @Override
    public boolean decRefCountOnGC() {
        return this.decRefCountOnGC;
    }

    @Override
    public IBDD getZero() {
        return BDDNativeProxy.zero;
    }

    @Override
    public IBDD getOne() {
        return BDDNativeProxy.one;
    }

    @Override
    public IBDD makeEquals(int var1, int var2) {
        return new BDDNativeProxy(BDDManagerNativeProxy.doMakeEquals(var1, var2));
    }

    @Override
    public IBDD makeSingleTuple(int start, int length, int value2) {
        return new BDDNativeProxy(BDDManagerNativeProxy.doMakeSingleTupleUnary(start, length, value2));
    }

    @Override
    public IBDD makeSingleTuple(int[] starts, int[] lengths, int[] values) {
        return new BDDNativeProxy(BDDManagerNativeProxy.doMakeSingleTuple(starts, lengths, values));
    }

    @Override
    public IBDD makeLessEqu(int start, int length, int value2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IBDD makeMoreEqu(int start, int length, int value2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void serialize(ObjectOutputStream out, IBDD[] nodes, ThreadCallback threadCallback, double progressPart, String message2) throws IOException {
        int[] roots = new int[nodes.length];
        for (int i2 = 0; i2 < nodes.length; ++i2) {
            roots[i2] = ((BDDNativeProxy)nodes[i2]).index;
        }
        BDDManagerNativeProxy.doSerialize(out, roots, threadCallback, progressPart, message2);
    }

    @Override
    public IBDD[] deserialize(ObjectInputStream in, ThreadCallback threadCallback, double progressPart, String message2) throws IOException, ClassNotFoundException {
        int[] roots = BDDManagerNativeProxy.doDeserialize(in, threadCallback, progressPart, message2);
        if (threadCallback.checkCancelled()) {
            return new IBDD[0];
        }
        IBDD[] result2 = new IBDD[roots.length];
        for (int i2 = 0; i2 < result2.length; ++i2) {
            result2[i2] = new BDDNativeProxy(roots[i2]);
        }
        return result2;
    }

    static native void doInit(int var0, int var1, int var2, boolean var3);

    static native void doCollectGarbage();

    static native int doGetMemoryState();

    static native int doGetZero();

    static native int doGetOne();

    static native String[] doGetInfo();

    static native int doMakeEquals(int var0, int var1);

    static native int doMakeSingleTupleUnary(int var0, int var1, int var2);

    static native int doMakeSingleTuple(int[] var0, int[] var1, int[] var2);

    static native void doSerialize(ObjectOutputStream var0, int[] var1, ThreadCallback var2, double var3, String var5) throws IOException;

    static native int[] doDeserialize(ObjectInputStream var0, ThreadCallback var1, double var2, String var4) throws IOException, ClassNotFoundException;
}

