/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.domains;

import com.jetbrains.sourceglider.domains.Domain;
import com.jetbrains.sourceglider.domains.DomainTypeOverflowException;
import com.jetbrains.sourceglider.symtable.SymbolTable;
import com.jetbrains.sourceglider.ui.Messages;
import com.jetbrains.sourceglider.ui.console.Console;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;

public class DomainType {
    private final SymbolTable symbolTable;
    private String name;
    private int numOfAttributes;
    private int bitLength;
    private boolean isGeneric;
    private Domain[] allocatedDomains;
    private static final int START_BIT_LENGTH = 4;
    private static final int BIT_LENGTH_INCREASE_STEP = 2;
    private static final int MAX_NUM_OF_DOMAINS = 8;
    private static final int MAX_DOMAIN_LENGTH = 30;

    public DomainType(String name, SymbolTable table) {
        this.name = name;
        this.isGeneric = false;
        this.symbolTable = table;
    }

    public void init() {
        this.numOfAttributes = 0;
        this.bitLength = 4;
    }

    public static DomainType createGenericDomainType(String name, SymbolTable symbolTable) {
        DomainType type2 = new DomainType(name, symbolTable);
        type2.isGeneric = true;
        return type2;
    }

    public int addAttribute() {
        ++this.numOfAttributes;
        if (1 << this.bitLength < this.numOfAttributes * 2) {
            if (this.symbolTable.allowsDomainResize()) {
                this.extendDomainType();
            } else {
                throw new DomainTypeOverflowException(this);
            }
        }
        return this.numOfAttributes - 1;
    }

    public int addAttributes(int attributesCnt) {
        this.numOfAttributes += attributesCnt;
        while (1 << this.bitLength < this.numOfAttributes * 2) {
            if (this.symbolTable.allowsDomainResize()) {
                this.extendDomainType();
                continue;
            }
            throw new DomainTypeOverflowException(this);
        }
        return this.numOfAttributes - 1;
    }

    public int getNumOfAttrs() {
        return this.numOfAttributes;
    }

    public int size() {
        return this.bitLength;
    }

    public String getName() {
        return this.name;
    }

    public String getMetaInfo(String key2) {
        Map<Object, String> map2 = this.symbolTable.getMetaInfo(this);
        if (map2 == null) {
            return null;
        }
        return map2.get(key2);
    }

    public boolean isRevealable() {
        return !"True".equals(this.getMetaInfo("NonRevealable"));
    }

    public boolean isGeneric() {
        return this.isGeneric;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DomainType that = (DomainType)o;
        return this.name != null ? this.name.equals(that.name) : that.name == null;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public Domain getDomain(int index) {
        if (index >= 8) {
            throw new RuntimeException(Messages.getString(DomainType.class.getName() + "-0"));
        }
        return this.allocatedDomains[index];
    }

    public void installDomains(int typeOrder) {
        this.allocatedDomains = new Domain[8];
        for (int i2 = 0; i2 < 8; ++i2) {
            int firstBit = (typeOrder * 8 + i2) * 30;
            this.allocatedDomains[i2] = new Domain(this, firstBit);
        }
    }

    private void extendDomainType() {
        this.bitLength += 2;
        if (this.bitLength > 30) {
            throw new RuntimeException(Messages.getString(DomainType.class.getName() + "-1"));
        }
    }

    public static void printDomainInfo(Console console, SymbolTable table) {
        DomainType[] types = table.getAvailableDomainTypes();
        console.println(Messages.getString(DomainType.class.getName() + "-2"));
        for (DomainType type2 : types) {
            console.println(type2.getName() + Messages.getString(DomainType.class.getName() + "-3") + type2.bitLength + Messages.getString(DomainType.class.getName() + "-4") + type2.numOfAttributes);
        }
    }

    public static Domain[] getCorrespondingDomains(DomainType[] types) {
        Domain[] domains = new Domain[types.length];
        for (int i2 = 0; i2 < types.length; ++i2) {
            int index = 0;
            for (int j = 0; j < i2; ++j) {
                if (types[j] != types[i2]) continue;
                ++index;
            }
            domains[i2] = types[i2].getDomain(index);
        }
        return domains;
    }

    public void serialize(ObjectOutputStream out) throws IOException {
        out.writeInt(this.numOfAttributes);
        out.writeInt(this.bitLength);
    }

    public void deserialize(ObjectInputStream in) throws IOException {
        this.numOfAttributes = in.readInt();
        this.bitLength = in.readInt();
    }
}

