/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.relations.incremental;

import com.jetbrains.sourceglider.atttributes.Attribute;
import com.jetbrains.sourceglider.bdd.IBDD;
import com.jetbrains.sourceglider.bdd.IBDDManager;
import com.jetbrains.sourceglider.bdd.javaimpl.BDDManagerJavaImpl;
import com.jetbrains.sourceglider.domains.Domain;
import com.jetbrains.sourceglider.domains.DomainType;
import com.jetbrains.sourceglider.relations.IRelation;
import com.jetbrains.sourceglider.relations.incremental.IncrementalRelationsManager;
import com.jetbrains.sourceglider.relations.incremental.RelationsCache;
import com.jetbrains.sourceglider.symtable.SymbolTable;
import com.jetbrains.sourceglider.ui.DummyThreadCallback;
import com.jetbrains.sourceglider.ui.IConfigs;
import com.jetbrains.sourceglider.ui.Messages;
import com.jetbrains.sourceglider.ui.ThreadCallback;
import com.jetbrains.sourceglider.utils.ArrayHelper;
import com.jetbrains.sourceglider.utils.SortedArrayHelper;
import java.util.HashSet;

public class IncrementalRelation
implements IRelation {
    private static final int OP_COMPLEMENT = 0;
    private static final int OP_INTERSECT = 1;
    private static final int OP_UNITE = 2;
    private static final int OP_EXISTS = 3;
    private static final int OP_RENAME = 4;
    private static final int OP_TC = 5;
    Domain[] domains;
    IBDD base;
    IBDD add;
    IBDD sub;
    IBDD result;
    int key;
    int bddSerialID;
    boolean isKilled;
    IncrementalRelationsManager relationsManager;
    IBDDManager bddManager;
    RelationsCache cache;

    IncrementalRelation(IncrementalRelationsManager manager, IBDD base, IBDD add2, IBDD sub, Domain[] domains, int key2) {
        this.relationsManager = manager;
        this.bddManager = this.relationsManager.bddManager;
        this.cache = this.relationsManager.cache;
        this.base = base;
        this.add = add2;
        this.sub = sub;
        this.domains = domains;
        this.key = key2;
        DummyThreadCallback threadCallback = new DummyThreadCallback();
        this.result = base.unite(add2, threadCallback).intersect(sub.complement(), threadCallback);
        this.bddSerialID = this.bddManager.getManagerSerialID();
    }

    @Override
    public Domain[] getDomains() {
        return this.domains;
    }

    @Override
    public Domain getDomain(int index) {
        return this.domains[index];
    }

    @Override
    public DomainType[] getDomainTypes() {
        DomainType[] types = new DomainType[this.domains.length];
        for (int i2 = 0; i2 < types.length; ++i2) {
            types[i2] = this.domains[i2].getType();
        }
        return types;
    }

    @Override
    public DomainType getDomainType(int index) {
        return this.domains[index].getType();
    }

    @Override
    public IRelation getClone() {
        this.base.incRefCount();
        this.add.incRefCount();
        this.sub.incRefCount();
        return new IncrementalRelation(this.relationsManager, this.base, this.add, this.sub, this.domains, this.key);
    }

    @Override
    public IRelation reorderDomains(Domain[] newDomains) {
        if (!ArrayHelper.setEqual(this.domains, newDomains)) {
            throw new RuntimeException(Messages.getString(IncrementalRelation.class.getName() + "-0"));
        }
        this.base.incRefCount();
        this.add.incRefCount();
        this.sub.incRefCount();
        return new IncrementalRelation(this.relationsManager, this.base, this.add, this.sub, newDomains, this.key);
    }

    @Override
    public int[][] getAllTuples(int numOfTuples) {
        int[][] result2;
        int[] perm = SortedArrayHelper.getAscendingPermutation(this.domains);
        int[] domStarts = new int[this.domains.length];
        int[] domLengths = new int[this.domains.length];
        int[] limits = new int[this.domains.length];
        for (int i2 = 0; i2 < this.domains.length; ++i2) {
            domStarts[i2] = this.domains[perm[i2]].getFirstVar();
            domLengths[i2] = this.domains[perm[i2]].size();
            limits[i2] = this.domains[perm[i2]].getType().getNumOfAttrs();
        }
        for (int[] aResult : result2 = this.result.getNTuples(domStarts, domLengths, limits, numOfTuples)) {
            SortedArrayHelper.applyInversePerm(aResult, perm);
        }
        return result2;
    }

    @Override
    public int[][] getAllTuples() {
        return this.getAllTuples(-1);
    }

    @Override
    public Attribute[][] getAttributes(int numOfTuples, SymbolTable symbolTable) {
        int[][] tuples = this.getAllTuples(numOfTuples);
        Attribute[][] result2 = new Attribute[tuples.length][this.domains.length];
        for (int i2 = 0; i2 < result2.length; ++i2) {
            for (int j = 0; j < tuples[i2].length; ++j) {
                result2[i2][j] = symbolTable.getAttribute(this.domains[j].getType(), tuples[i2][j]);
            }
        }
        return result2;
    }

    @Override
    public Attribute[][] getAttributes(SymbolTable symbolTable) {
        return this.getAttributes(-1, symbolTable);
    }

    @Override
    public long getNumOfTuples() {
        int[] perm = SortedArrayHelper.getAscendingPermutation(this.domains);
        int[] domStarts = new int[this.domains.length];
        int[] domLengths = new int[this.domains.length];
        int[] limits = new int[this.domains.length];
        for (int i2 = 0; i2 < this.domains.length; ++i2) {
            domStarts[i2] = this.domains[perm[i2]].getFirstVar();
            domLengths[i2] = this.domains[perm[i2]].size();
            limits[i2] = this.domains[perm[i2]].getType().getNumOfAttrs();
        }
        return this.result.getNumOfTuples(domStarts, domLengths, limits);
    }

    @Override
    public long getNumOfBDDNodes() {
        throw new RuntimeException(Messages.getString(IncrementalRelation.class.getName() + "-11"));
    }

    @Override
    public IRelation addTuple(int[] values) {
        int[] perm = SortedArrayHelper.getAscendingPermutation(this.domains);
        int[] domStarts = new int[this.domains.length];
        int[] domLengths = new int[this.domains.length];
        SortedArrayHelper.applyPerm(values, perm);
        for (int i2 = 0; i2 < this.domains.length; ++i2) {
            domStarts[i2] = this.domains[perm[i2]].getFirstVar();
            domLengths[i2] = this.domains[perm[i2]].size();
        }
        this.base.incRefCount();
        this.sub.incRefCount();
        return new IncrementalRelation(this.relationsManager, this.base, this.add.addTuple(domStarts, domLengths, values), this.sub, this.domains, -1);
    }

    IncrementalRelation saveResult() {
        this.cache.save(this.key, this.result);
        return this;
    }

    @Override
    public IRelation complement(ThreadCallback threadCallback) {
        int newKey = this.cache.getKey(this.key, 0);
        this.sub.incRefCount();
        this.add.incRefCount();
        return new IncrementalRelation(this.relationsManager, this.cache.getLastCached(newKey, true), this.sub, this.add, this.domains, newKey).saveResult();
    }

    private IRelation intersect(IRelation relation, Domain[] domains, ThreadCallback threadCallback) {
        IncrementalRelation rel = (IncrementalRelation)relation;
        int newKey = this.cache.getKey(this.key, rel.key, 1);
        IBDD r = rel.result;
        IBDD lo = this.base;
        IBDD la = this.add;
        IBDD ls = this.sub;
        IBDD ra = rel.add;
        IBDD rs = rel.sub;
        IBDD t = la.intersect(r, threadCallback).intersect(ls.intersect(r, threadCallback).complement(), threadCallback);
        IBDD newAdd = lo.intersect(ra, threadCallback).unite(t, threadCallback);
        IBDD newSub = lo.intersect(rs, threadCallback).unite(ls.intersect(r, threadCallback), threadCallback).intersect(t.complement(), threadCallback);
        return new IncrementalRelation(this.relationsManager, this.cache.getLastCached(newKey), newAdd, newSub, domains, newKey).saveResult();
    }

    @Override
    public IRelation intersect(IRelation relation, ThreadCallback threadCallback) {
        if (!ArrayHelper.equals(this.domains, ((IncrementalRelation)relation).domains)) {
            throw new RuntimeException(Messages.getString(IncrementalRelation.class.getName() + "-1"));
        }
        return this.intersect(relation, this.domains, threadCallback);
    }

    @Override
    public IRelation unsafeIntersect(IRelation relation, ThreadCallback threadCallback) {
        return this.intersect(relation, (Domain[])ArrayHelper.uniteArrays(this.domains, ((IncrementalRelation)relation).domains, Domain.class), threadCallback);
    }

    private IRelation unite(IRelation relation, Domain[] domains, ThreadCallback threadCallback) {
        IncrementalRelation rel = (IncrementalRelation)relation;
        int newKey = this.cache.getKey(this.key, rel.key, 2);
        IBDD r = rel.result;
        IBDD lo = this.base;
        IBDD la = this.add;
        IBDD ls = this.sub;
        IBDD ra = rel.add;
        IBDD rs = rel.sub;
        IBDD newAdd = la.unite(ra, threadCallback);
        IBDD newSub = this.bddManager.getZero();
        if (!rs.isZero()) {
            newSub = rs.intersect(lo.unite(la, threadCallback).complement(), threadCallback);
        }
        if (!ls.isZero()) {
            newSub = newSub.unite(ls.intersect(r.complement(), threadCallback), threadCallback);
        }
        return new IncrementalRelation(this.relationsManager, this.cache.getLastCached(newKey), newAdd, newSub, domains, newKey).saveResult();
    }

    @Override
    public IRelation unite(IRelation relation, ThreadCallback threadCallback) {
        if (!ArrayHelper.equals(this.domains, ((IncrementalRelation)relation).domains)) {
            throw new RuntimeException(Messages.getString(IncrementalRelation.class.getName() + "-2"));
        }
        return this.unite(relation, this.domains, threadCallback);
    }

    @Override
    public IRelation unsafeUnite(IRelation relation, ThreadCallback threadCallback) {
        return this.unite(relation, (Domain[])ArrayHelper.uniteArrays(this.domains, ((IncrementalRelation)relation).domains, Domain.class), threadCallback);
    }

    @Override
    public IRelation subtract(IRelation relation, ThreadCallback threadCallback) {
        return this.intersect(relation.complement(threadCallback), threadCallback);
    }

    @Override
    public IRelation exists(int index, ThreadCallback threadCallback) {
        Domain domain = this.domains[index];
        Domain[] newDomains = (Domain[])ArrayHelper.deleteElement((Object[])this.domains, index, Domain.class);
        int newKey = this.cache.getKey(this.key, 3);
        IBDD newAdd = this.add.exists(domain.getFirstVar(), domain.size(), threadCallback);
        IBDD newSub = this.sub.exists(domain.getFirstVar(), domain.size(), threadCallback).intersect(this.result.intersect(this.sub.exists(domain.getFirstVar(), domain.size(), threadCallback), threadCallback).exists(domain.getFirstVar(), domain.size(), threadCallback).complement(), threadCallback);
        return new IncrementalRelation(this.relationsManager, this.cache.getLastCached(newKey), newAdd, newSub, newDomains, newKey).saveResult();
    }

    @Override
    public IRelation exists(Domain domain, ThreadCallback threadCallback) {
        int index = ArrayHelper.searchElement(this.domains, domain);
        if (index == -1) {
            throw new RuntimeException(Messages.getString(IncrementalRelation.class.getName() + "-3"));
        }
        return this.exists(index, threadCallback);
    }

    private IBDD renameSafe(IBDD node, Domain oldDomain, Domain newDomain, ThreadCallback threadCallback) {
        IBDD result2 = node;
        if (oldDomain.compareTo(newDomain) > 0) {
            for (int i2 = 0; i2 < oldDomain.size(); ++i2) {
                IBDD pair = this.bddManager.makeEquals(oldDomain.getFirstVar() + i2, newDomain.getFirstVar() + i2);
                result2 = result2.intersect(pair, threadCallback).exists(oldDomain.getFirstVar() + i2, threadCallback);
            }
        } else {
            for (int i3 = oldDomain.size() - 1; i3 >= 0; --i3) {
                IBDD pair = this.bddManager.makeEquals(oldDomain.getFirstVar() + i3, newDomain.getFirstVar() + i3);
                result2 = result2.intersect(pair, threadCallback).exists(oldDomain.getFirstVar() + i3, threadCallback);
            }
        }
        return result2;
    }

    @Override
    public IRelation rename(int domainIndex, Domain newDomain, ThreadCallback threadCallback) {
        Domain oldDomain = this.domains[domainIndex];
        if (!oldDomain.getType().equals(newDomain.getType())) {
            throw new RuntimeException(Messages.getString(IncrementalRelation.class.getName() + "-4"));
        }
        if (oldDomain.equals(newDomain)) {
            return this;
        }
        Domain[] newDomains = (Domain[])this.domains.clone();
        newDomains[domainIndex] = newDomain;
        int firstVar = oldDomain.getFirstVar() + oldDomain.size();
        int length = newDomain.getFirstVar() + newDomain.size() - oldDomain.getFirstVar() - oldDomain.size();
        if (oldDomain.getFirstVar() > newDomain.getFirstVar()) {
            firstVar = newDomain.getFirstVar();
            length = oldDomain.getFirstVar() - newDomain.getFirstVar();
        }
        int newKey = this.cache.getKey(this.key, 4);
        IBDD newAdd = this.add.testVars(firstVar, length) ? this.renameSafe(this.add, oldDomain, newDomain, threadCallback) : this.add.rename(oldDomain.getFirstVar(), oldDomain.size(), newDomain.getFirstVar() - oldDomain.getFirstVar(), threadCallback);
        IBDD newSub = this.sub.testVars(firstVar, length) ? this.renameSafe(this.sub, oldDomain, newDomain, threadCallback) : this.sub.rename(oldDomain.getFirstVar(), oldDomain.size(), newDomain.getFirstVar() - oldDomain.getFirstVar(), threadCallback);
        return new IncrementalRelation(this.relationsManager, this.cache.getLastCached(newKey), newAdd, newSub, newDomains, newKey).saveResult();
    }

    @Override
    public IRelation rename(Domain oldDomain, Domain newDomain, ThreadCallback threadCallback) {
        int index = ArrayHelper.searchElement(this.domains, oldDomain);
        if (index == -1) {
            throw new RuntimeException(Messages.getString(IncrementalRelation.class.getName() + "-5"));
        }
        return this.rename(index, newDomain, threadCallback);
    }

    @Override
    public IRelation fastRename(Domain[] newDomains, ThreadCallback threadCallback) {
        int i2;
        for (int i3 = 0; i3 < this.domains.length; ++i3) {
            if (this.domains[i3].getType() == newDomains[i3].getType()) continue;
            throw new RuntimeException(Messages.getString(IncrementalRelation.class.getName() + "-6"));
        }
        IncrementalRelation result2 = this;
        boolean[] safeRename = new boolean[this.domains.length];
        block1: for (i2 = 0; i2 < this.domains.length; ++i2) {
            int j;
            HashSet<Domain> set2 = new HashSet<Domain>();
            safeRename[i2] = false;
            Domain newDomain = newDomains[i2];
            for (j = 0; j < this.domains.length; ++j) {
                if (i2 == j) continue;
                Domain oldDomain = result2.domains[j];
                if (oldDomain.getType() == newDomain.getType()) {
                    set2.add(oldDomain);
                }
                if (!oldDomain.equals(newDomain)) continue;
                safeRename[i2] = true;
            }
            if (safeRename[i2]) {
                for (Domain newDomain1 : newDomains) {
                    set2.add(newDomain1);
                }
                j = 0;
                while (true) {
                    Domain domain;
                    if (!set2.contains(domain = newDomain.getType().getDomain(j))) {
                        result2 = (IncrementalRelation)result2.rename(i2, domain, threadCallback);
                        continue block1;
                    }
                    ++j;
                }
            }
            result2 = (IncrementalRelation)result2.rename(i2, newDomains[i2], threadCallback);
        }
        for (i2 = 0; i2 < this.domains.length; ++i2) {
            if (!safeRename[i2]) continue;
            result2 = (IncrementalRelation)result2.rename(i2, newDomains[i2], threadCallback);
        }
        return result2;
    }

    @Override
    public IRelation relprod(IRelation relation, Domain domain, ThreadCallback threadCallback) {
        int index = ArrayHelper.searchElement(this.domains, domain);
        if (index == -1) {
            throw new RuntimeException(Messages.getString(IncrementalRelation.class.getName() + "-7"));
        }
        return this.relprod(relation, index, threadCallback);
    }

    @Override
    public IRelation relprod(IRelation relation, int indexInLeft, ThreadCallback threadCallback) {
        return this.unsafeIntersect(relation, threadCallback).exists(this.domains[indexInLeft], threadCallback);
    }

    @Override
    public IRelation project(int index, int attribute, ThreadCallback threadCallback) {
        IncrementalRelation deletedDomain = (IncrementalRelation)this.relationsManager.makeSingleTuple(this.domains[index], attribute);
        return this.relprod((IRelation)deletedDomain, index, threadCallback);
    }

    @Override
    public IRelation transitiveClosure(ThreadCallback threadCallback) {
        if (this.domains.length != 2 || !this.domains[0].getType().equals(this.domains[1].getType())) {
            throw new RuntimeException(Messages.getString(IncrementalRelation.class.getName() + "-8"));
        }
        int n = this.domains[0].getType().getNumOfAttrs();
        IBDD result2 = this.result;
        for (int k = 0; k < n && !threadCallback.checkCancelled(); ++k) {
            IBDD left = result2.intersect(this.bddManager.makeSingleTuple(this.domains[1].getFirstVar(), this.domains[1].size(), k), threadCallback).exists(this.domains[1].getFirstVar(), this.domains[1].size(), threadCallback);
            IBDD right = result2.intersect(this.bddManager.makeSingleTuple(this.domains[0].getFirstVar(), this.domains[0].size(), k), threadCallback).exists(this.domains[0].getFirstVar(), this.domains[0].size(), threadCallback);
            result2 = result2.unite(left.intersect(right, threadCallback), threadCallback);
        }
        return this.relationsManager.makeExplicitIncremental(result2, this.cache.getKey(this.key, 5), this.domains, threadCallback);
    }

    @Override
    public boolean equals(IRelation relation) {
        if (!ArrayHelper.equals(this.domains, ((IncrementalRelation)relation).domains)) {
            throw new RuntimeException(Messages.getString(IncrementalRelation.class.getName() + "-9"));
        }
        return this.result.equals(((IncrementalRelation)relation).result);
    }

    @Override
    public boolean contains(IRelation relation, ThreadCallback threadCallback) {
        if (!ArrayHelper.equals(this.domains, ((IncrementalRelation)relation).domains)) {
            throw new RuntimeException(Messages.getString(IncrementalRelation.class.getName() + "-10"));
        }
        return relation.subtract(this, threadCallback).isEmpty();
    }

    @Override
    public boolean isEmpty() {
        return this.result.isZero();
    }

    @Override
    public void kill() {
        this.isKilled = true;
        this.base.decRefCount();
        this.add.decRefCount();
        this.sub.decRefCount();
        this.result.decRefCount();
    }

    public void finalize() {
        if (!this.isKilled && this.bddSerialID == this.bddManager.getManagerSerialID()) {
            this.base.decRefCount();
            this.add.decRefCount();
            this.sub.decRefCount();
            this.result.decRefCount();
        }
    }

    public void main(String[] _) {
        int[][] list;
        this.bddManager = new BDDManagerJavaImpl();
        this.bddManager.init(new IConfigs.ConfigsStub());
        IBDD a = this.bddManager.getZero();
        a = a.addTuple(new int[]{0, 10}, new int[]{10, 10}, new int[]{1, 2});
        a = a.addTuple(new int[]{0, 10}, new int[]{10, 10}, new int[]{2, 3});
        a = a.addTuple(new int[]{0, 10}, new int[]{10, 10}, new int[]{3, 4});
        IBDD b = this.bddManager.getZero();
        b = b.addTuple(new int[]{10, 20}, new int[]{10, 10}, new int[]{3, 4});
        b = b.addTuple(new int[]{10, 20}, new int[]{10, 10}, new int[]{4, 5});
        b = b.addTuple(new int[]{10, 20}, new int[]{10, 10}, new int[]{5, 6});
        a = a.relprod(b, 10, 10, new DummyThreadCallback());
        for (int[] aList : list = a.getNTuples(new int[]{0, 20}, new int[]{10, 10}, new int[]{100, 100}, -1)) {
            for (int j = 0; j < 2; ++j) {
                System.out.print(aList[j] + " ");
            }
            System.out.println();
        }
    }
}

