/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.relations.incremental;

import com.jetbrains.sourceglider.bdd.IBDD;
import com.jetbrains.sourceglider.bdd.IBDDManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RelationsCache {
    static final int NO_KEY = -1;
    private static final int CACHE_SIZE_MASK = 65535;
    private KeyEntry[] keysCache = new KeyEntry[65536];
    private int firstFreeKey;
    private List<ResultsCache> resultsCaches = new ArrayList<ResultsCache>();
    private Map<String, Integer> repositoryRelationsKeys = new HashMap<String, Integer>();
    private IBDDManager bddManager;

    public RelationsCache(IBDDManager bddManager) {
        this.bddManager = bddManager;
    }

    public void rewindCaches() {
        for (ResultsCache resultsCache : this.resultsCaches) {
            resultsCache.rewind();
        }
    }

    public int getRepositoryRelationKey(String relation) {
        if (!this.repositoryRelationsKeys.containsKey(relation)) {
            this.repositoryRelationsKeys.put(relation, new Integer(this.firstFreeKey++));
            this.resultsCaches.add(new ResultsCache());
        }
        return this.repositoryRelationsKeys.get(relation);
    }

    public int getKey(int leftKey, int rightKey, int opCode) {
        if (leftKey == -1 || rightKey == -1) {
            return -1;
        }
        int hashCode = (leftKey * 31 + rightKey) * 31 + opCode;
        KeyEntry entry = this.keysCache[hashCode & 0xFFFF];
        while (entry != null) {
            if (entry.leftKey == leftKey && entry.rightKey == rightKey && entry.opCode == opCode) {
                return entry.key;
            }
            entry = entry.next;
        }
        entry = new KeyEntry(leftKey, rightKey, opCode, this.firstFreeKey++);
        entry.next = this.keysCache[hashCode & 0xFFFF];
        this.keysCache[hashCode & 0xFFFF] = entry;
        this.resultsCaches.add(new ResultsCache());
        return this.firstFreeKey - 1;
    }

    public int getKey(int operandKey, int opCode) {
        if (operandKey == -1) {
            return -1;
        }
        return this.getKey(operandKey, 0, opCode);
    }

    public int getKey(int value2) {
        return this.getKey(0, 0, value2);
    }

    public IBDD getLastCached(int key2, boolean full) {
        if (key2 == -1) {
            return full ? this.bddManager.getOne() : this.bddManager.getZero();
        }
        return this.resultsCaches.get(key2).getLast(full);
    }

    public IBDD getLastCached(int key2) {
        return this.getLastCached(key2, false);
    }

    public void save(int key2, IBDD result2) {
        if (key2 != -1) {
            this.resultsCaches.get(key2).save(result2);
        }
    }

    private class ResultsCache {
        private int curIteration;
        private List<IBDD> results = new ArrayList<IBDD>();

        private ResultsCache() {
        }

        public void rewind() {
            this.curIteration = 0;
        }

        IBDD getLast(boolean full) {
            if (this.curIteration < this.results.size()) {
                IBDD result2 = this.results.get(this.curIteration);
                result2.incRefCount();
                return result2;
            }
            return full ? RelationsCache.this.bddManager.getOne() : RelationsCache.this.bddManager.getZero();
        }

        void save(IBDD result2) {
            result2.incRefCount();
            if (this.curIteration < this.results.size()) {
                this.results.get(this.curIteration).decRefCount();
                this.results.set(this.curIteration, result2);
            } else {
                this.results.add(result2);
            }
            ++this.curIteration;
        }
    }

    private static class KeyEntry {
        int leftKey;
        int rightKey;
        Object operand;
        int opCode;
        KeyEntry next;
        int key;

        public KeyEntry(int leftKey, int rightKey, int opCode, int key2) {
            this.leftKey = leftKey;
            this.rightKey = rightKey;
            this.opCode = opCode;
            this.key = key2;
        }
    }
}

