/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.relations.plain;

import com.jetbrains.sourceglider.atttributes.Attribute;
import com.jetbrains.sourceglider.bdd.IBDD;
import com.jetbrains.sourceglider.bdd.IBDDManager;
import com.jetbrains.sourceglider.domains.Domain;
import com.jetbrains.sourceglider.domains.DomainType;
import com.jetbrains.sourceglider.relations.IRelation;
import com.jetbrains.sourceglider.relations.plain.PlainRelationsManager;
import com.jetbrains.sourceglider.symtable.SymbolTable;
import com.jetbrains.sourceglider.ui.Messages;
import com.jetbrains.sourceglider.ui.ThreadCallback;
import com.jetbrains.sourceglider.utils.ArrayHelper;
import com.jetbrains.sourceglider.utils.SortedArrayHelper;
import java.util.Collections;
import java.util.HashSet;

public class PlainRelation
implements IRelation {
    IBDD root;
    Domain[] domains;
    int bddSerialID;
    boolean isKilled;
    boolean isPersistent;
    IBDDManager bddManager;
    PlainRelationsManager relationsManager;

    PlainRelation(PlainRelationsManager manager, IBDD root, Domain[] domains) {
        this.relationsManager = manager;
        this.bddManager = manager.bddManager;
        this.root = root;
        this.domains = domains;
        this.bddSerialID = this.bddManager.getManagerSerialID();
    }

    PlainRelation(PlainRelationsManager manager, Domain[] domains) {
        this.relationsManager = manager;
        this.bddManager = manager.bddManager;
        this.root = this.bddManager.getZero();
        this.domains = domains;
        this.bddSerialID = this.bddManager.getManagerSerialID();
    }

    PlainRelation(PlainRelationsManager manager, DomainType[] types) {
        this.relationsManager = manager;
        this.bddManager = manager.bddManager;
        this.root = this.bddManager.getZero();
        this.domains = DomainType.getCorrespondingDomains(types);
        this.bddSerialID = this.bddManager.getManagerSerialID();
    }

    PlainRelation(PlainRelationsManager manager, Domain[] domains, boolean full) {
        this.relationsManager = manager;
        this.bddManager = manager.bddManager;
        this.root = full ? this.bddManager.getOne() : this.bddManager.getZero();
        this.domains = domains;
        this.bddSerialID = this.bddManager.getManagerSerialID();
    }

    @Override
    public Domain[] getDomains() {
        return this.domains;
    }

    @Override
    public Domain getDomain(int index) {
        return this.domains[index];
    }

    @Override
    public DomainType[] getDomainTypes() {
        DomainType[] types = new DomainType[this.domains.length];
        for (int i2 = 0; i2 < types.length; ++i2) {
            types[i2] = this.domains[i2].getType();
        }
        return types;
    }

    @Override
    public DomainType getDomainType(int index) {
        return this.domains[index].getType();
    }

    @Override
    public IRelation getClone() {
        this.root.incRefCount();
        return new PlainRelation(this.relationsManager, this.root, this.domains);
    }

    @Override
    public IRelation reorderDomains(Domain[] newDomains) {
        if (!ArrayHelper.setEqual(this.domains, newDomains)) {
            throw new RuntimeException(Messages.getString(PlainRelation.class.getName() + "-0"));
        }
        this.root.incRefCount();
        return new PlainRelation(this.relationsManager, this.root, newDomains);
    }

    @Override
    public int[][] getAllTuples(int numOfTuples) {
        int[][] result2;
        int[] perm = SortedArrayHelper.getAscendingPermutation(this.domains);
        int[] domStarts = new int[this.domains.length];
        int[] domLengths = new int[this.domains.length];
        int[] limits = new int[this.domains.length];
        for (int i2 = 0; i2 < this.domains.length; ++i2) {
            domStarts[i2] = this.domains[perm[i2]].getFirstVar();
            domLengths[i2] = this.domains[perm[i2]].size();
            limits[i2] = this.domains[perm[i2]].getType().getNumOfAttrs();
        }
        for (int[] aResult : result2 = this.root.getNTuples(domStarts, domLengths, limits, numOfTuples)) {
            SortedArrayHelper.applyInversePerm(aResult, perm);
        }
        return result2;
    }

    @Override
    public int[][] getAllTuples() {
        return this.getAllTuples(-1);
    }

    @Override
    public Attribute[][] getAttributes(int numOfTuples, SymbolTable symbolTable) {
        int[][] tuples = this.getAllTuples(numOfTuples);
        Attribute[][] result2 = new Attribute[tuples.length][this.domains.length];
        for (int i2 = 0; i2 < result2.length; ++i2) {
            for (int j = 0; j < tuples[i2].length; ++j) {
                result2[i2][j] = symbolTable.getAttribute(this.domains[j].getType(), tuples[i2][j]);
            }
        }
        return result2;
    }

    @Override
    public Attribute[][] getAttributes(SymbolTable symbolTable) {
        return this.getAttributes(-1, symbolTable);
    }

    @Override
    public long getNumOfTuples() {
        int[] perm = SortedArrayHelper.getAscendingPermutation(this.domains);
        int[] domStarts = new int[this.domains.length];
        int[] domLengths = new int[this.domains.length];
        int[] limits = new int[this.domains.length];
        for (int i2 = 0; i2 < this.domains.length; ++i2) {
            domStarts[i2] = this.domains[perm[i2]].getFirstVar();
            domLengths[i2] = this.domains[perm[i2]].size();
            limits[i2] = this.domains[perm[i2]].getType().getNumOfAttrs();
        }
        return this.root.getNumOfTuples(domStarts, domLengths, limits);
    }

    @Override
    public long getNumOfBDDNodes() {
        return this.root.getNumOfNodes();
    }

    @Override
    public IRelation addTuple(int[] values) {
        int[] perm = SortedArrayHelper.getAscendingPermutation(this.domains);
        int[] domStarts = new int[this.domains.length];
        int[] domLengths = new int[this.domains.length];
        SortedArrayHelper.applyPerm(values, perm);
        for (int i2 = 0; i2 < this.domains.length; ++i2) {
            domStarts[i2] = this.domains[perm[i2]].getFirstVar();
            domLengths[i2] = this.domains[perm[i2]].size();
        }
        return new PlainRelation(this.relationsManager, this.root.addTuple(domStarts, domLengths, values), this.domains);
    }

    @Override
    public IRelation complement(ThreadCallback threadCallback) {
        IBDD node = this.root.complement();
        for (Domain domain : this.domains) {
            IBDD oldNode = node;
            IBDD constraint = this.bddManager.makeLessEqu(domain.getFirstVar(), domain.size(), domain.getType().getNumOfAttrs() - 1);
            node = node.intersect(constraint, threadCallback);
            constraint.decRefCount();
            oldNode.decRefCount();
        }
        return new PlainRelation(this.relationsManager, node, this.domains);
    }

    @Override
    public IRelation intersect(IRelation relation, ThreadCallback threadCallback) {
        if (!ArrayHelper.equals(this.domains, ((PlainRelation)relation).domains)) {
            throw new RuntimeException(Messages.getString(PlainRelation.class.getName() + "-1"));
        }
        return new PlainRelation(this.relationsManager, this.root.intersect(((PlainRelation)relation).root, threadCallback), this.domains);
    }

    @Override
    public IRelation unsafeIntersect(IRelation relation, ThreadCallback threadCallback) {
        if (((PlainRelation)relation).domains == null) {
            return new PlainRelation(this.relationsManager, this.root.intersect(((PlainRelation)relation).root, threadCallback), null);
        }
        return new PlainRelation(this.relationsManager, this.root.intersect(((PlainRelation)relation).root, threadCallback), (Domain[])ArrayHelper.uniteArrays(this.domains, ((PlainRelation)relation).domains, Domain.class));
    }

    @Override
    public IRelation unite(IRelation relation, ThreadCallback threadCallback) {
        if (!ArrayHelper.equals(this.domains, ((PlainRelation)relation).domains)) {
            throw new RuntimeException(Messages.getString(PlainRelation.class.getName() + "-2"));
        }
        return new PlainRelation(this.relationsManager, this.root.unite(((PlainRelation)relation).root, threadCallback), this.domains);
    }

    @Override
    public IRelation unsafeUnite(IRelation relation, ThreadCallback threadCallback) {
        return new PlainRelation(this.relationsManager, this.root.unite(((PlainRelation)relation).root, threadCallback), (Domain[])ArrayHelper.uniteArrays(this.domains, ((PlainRelation)relation).domains, Domain.class));
    }

    @Override
    public IRelation subtract(IRelation relation, ThreadCallback threadCallback) {
        IRelation complement = relation.complement(threadCallback);
        IRelation result2 = this.unsafeIntersect(complement, threadCallback);
        complement.kill();
        return result2;
    }

    private PlainRelation existsVar(int var, ThreadCallback threadCallback) {
        return new PlainRelation(this.relationsManager, this.root.exists(var, threadCallback), null);
    }

    @Override
    public IRelation exists(int index, ThreadCallback threadCallback) {
        Domain domain = this.domains[index];
        Domain[] newDomains = (Domain[])ArrayHelper.deleteElement((Object[])this.domains, index, Domain.class);
        return new PlainRelation(this.relationsManager, this.root.exists(domain.getFirstVar(), domain.size(), threadCallback), newDomains);
    }

    @Override
    public IRelation exists(Domain domain, ThreadCallback threadCallback) {
        int index = ArrayHelper.searchElement(this.domains, domain);
        if (index == -1) {
            throw new RuntimeException(Messages.getString(PlainRelation.class.getName() + "-3"));
        }
        return this.exists(index, threadCallback);
    }

    private PlainRelation renameSafe(Domain oldDomain, Domain newDomain, ThreadCallback threadCallback) {
        PlainRelation result2 = (PlainRelation)this.getClone();
        if (oldDomain.compareTo(newDomain) > 0) {
            for (int i2 = 0; i2 < oldDomain.size(); ++i2) {
                PlainRelation pair = new PlainRelation(this.relationsManager, this.bddManager.makeEquals(oldDomain.getFirstVar() + i2, newDomain.getFirstVar() + i2), null);
                PlainRelation oldResult = result2;
                result2 = (PlainRelation)result2.unsafeIntersect(pair, threadCallback);
                oldResult.kill();
                pair.kill();
                oldResult = result2;
                result2 = result2.existsVar(oldDomain.getFirstVar() + i2, threadCallback);
                oldResult.kill();
            }
        } else {
            for (int i3 = oldDomain.size() - 1; i3 >= 0; --i3) {
                PlainRelation pair = new PlainRelation(this.relationsManager, this.bddManager.makeEquals(oldDomain.getFirstVar() + i3, newDomain.getFirstVar() + i3), null);
                PlainRelation oldResult = result2;
                result2 = (PlainRelation)result2.unsafeIntersect(pair, threadCallback);
                oldResult.kill();
                pair.kill();
                oldResult = result2;
                result2 = result2.existsVar(oldDomain.getFirstVar() + i3, threadCallback);
                oldResult.kill();
            }
        }
        return result2;
    }

    @Override
    public IRelation rename(int domainIndex, Domain newDomain, ThreadCallback threadCallback) {
        Domain oldDomain = this.domains[domainIndex];
        if (!oldDomain.getType().equals(newDomain.getType())) {
            throw new RuntimeException(Messages.getString(PlainRelation.class.getName() + "-4"));
        }
        if (oldDomain.equals(newDomain)) {
            return this.getClone();
        }
        Domain[] newDomains = (Domain[])this.domains.clone();
        newDomains[domainIndex] = newDomain;
        int firstVar = oldDomain.getFirstVar() + oldDomain.size();
        int length = newDomain.getFirstVar() + newDomain.size() - oldDomain.getFirstVar() - oldDomain.size();
        if (oldDomain.getFirstVar() > newDomain.getFirstVar()) {
            firstVar = newDomain.getFirstVar();
            length = oldDomain.getFirstVar() - newDomain.getFirstVar();
        }
        if (this.root.testVars(firstVar, length)) {
            PlainRelation result2 = this.renameSafe(oldDomain, newDomain, threadCallback);
            result2.domains = newDomains;
            return result2;
        }
        return new PlainRelation(this.relationsManager, this.root.rename(oldDomain.getFirstVar(), oldDomain.size(), newDomain.getFirstVar() - oldDomain.getFirstVar(), threadCallback), newDomains);
    }

    @Override
    public IRelation rename(Domain oldDomain, Domain newDomain, ThreadCallback threadCallback) {
        int index = ArrayHelper.searchElement(this.domains, oldDomain);
        if (index == -1) {
            throw new RuntimeException(Messages.getString(PlainRelation.class.getName() + "-5"));
        }
        return this.rename(index, newDomain, threadCallback);
    }

    @Override
    public IRelation fastRename(Domain[] newDomains, ThreadCallback threadCallback) {
        int i2;
        for (int i3 = 0; i3 < this.domains.length; ++i3) {
            if (this.domains[i3].getType() == newDomains[i3].getType()) continue;
            throw new RuntimeException(Messages.getString(PlainRelation.class.getName() + "-6"));
        }
        IRelation result2 = this.getClone();
        boolean[] safeRename = new boolean[this.domains.length];
        block1: for (i2 = 0; i2 < this.domains.length; ++i2) {
            int j;
            HashSet<Domain> set2 = new HashSet<Domain>();
            safeRename[i2] = false;
            Domain newDomain = newDomains[i2];
            for (j = 0; j < this.domains.length; ++j) {
                if (i2 == j) continue;
                Domain oldDomain = ((PlainRelation)result2).domains[j];
                if (oldDomain.getType() == newDomain.getType()) {
                    set2.add(oldDomain);
                }
                if (!oldDomain.equals(newDomain)) continue;
                safeRename[i2] = true;
            }
            if (safeRename[i2]) {
                Collections.addAll(set2, newDomains);
                j = 0;
                while (true) {
                    Domain domain;
                    if (!set2.contains(domain = newDomain.getType().getDomain(j))) {
                        IRelation oldResult = result2;
                        result2 = result2.rename(i2, domain, threadCallback);
                        oldResult.kill();
                        continue block1;
                    }
                    ++j;
                }
            }
            IRelation oldResult = result2;
            result2 = result2.rename(i2, newDomains[i2], threadCallback);
            oldResult.kill();
        }
        for (i2 = 0; i2 < this.domains.length; ++i2) {
            if (!safeRename[i2]) continue;
            IRelation oldResult = result2;
            result2 = result2.rename(i2, newDomains[i2], threadCallback);
            oldResult.kill();
        }
        return result2;
    }

    @Override
    public IRelation relprod(IRelation relation, int indexInLeft, ThreadCallback threadCallback) {
        int firstVar = this.domains[indexInLeft].getFirstVar();
        int length = this.domains[indexInLeft].size();
        Object[] newDomains = (Domain[])ArrayHelper.uniteArrays(this.domains, ((PlainRelation)relation).domains, Domain.class);
        newDomains = (Domain[])ArrayHelper.deleteElement(newDomains, this.domains[indexInLeft], Domain.class);
        return new PlainRelation(this.relationsManager, this.root.relprod(((PlainRelation)relation).root, firstVar, length, threadCallback), (Domain[])newDomains);
    }

    @Override
    public IRelation relprod(IRelation relation, Domain domain, ThreadCallback threadCallback) {
        int index = ArrayHelper.searchElement(this.domains, domain);
        if (index == -1) {
            throw new RuntimeException(Messages.getString(PlainRelation.class.getName() + "-7"));
        }
        return this.relprod(relation, index, threadCallback);
    }

    public IRelation relprod(IRelation relation, Domain[] doms, ThreadCallback threadCallback) {
        PlainRelation result2 = (PlainRelation)this.unsafeIntersect(relation, threadCallback);
        for (Domain dom : doms) {
            int index = ArrayHelper.searchElement(result2.domains, dom);
            if (index == -1) {
                throw new RuntimeException(Messages.getString(PlainRelation.class.getName() + "-8"));
            }
            PlainRelation oldResult = result2;
            result2 = (PlainRelation)result2.exists(index, threadCallback);
            oldResult.kill();
        }
        return result2;
    }

    @Override
    public IRelation project(int index, int attribute, ThreadCallback threadCallback) {
        IRelation deletedDomain = this.relationsManager.makeSingleTuple(this.domains[index], attribute);
        IRelation result2 = this.relprod(deletedDomain, index, threadCallback);
        deletedDomain.kill();
        return result2;
    }

    @Override
    public IRelation transitiveClosure(ThreadCallback threadCallback) {
        if (this.domains.length != 2 || !this.domains[0].getType().equals(this.domains[1].getType())) {
            throw new RuntimeException(Messages.getString(PlainRelation.class.getName() + "-9"));
        }
        int n = this.domains[0].getType().getNumOfAttrs();
        IRelation result2 = this.getClone();
        for (int k = 0; k < n; ++k) {
            if (threadCallback.checkCancelled()) {
                return result2;
            }
            IRelation proj1 = result2.project(1, k, threadCallback);
            IRelation proj2 = result2.project(0, k, threadCallback);
            IRelation work = proj1.unsafeIntersect(proj2, threadCallback);
            IRelation oldResult = result2;
            result2 = result2.unite(work, threadCallback);
            proj1.kill();
            proj2.kill();
            work.kill();
            oldResult.kill();
        }
        return result2;
    }

    @Override
    public boolean equals(IRelation relation) {
        if (!ArrayHelper.equals(this.domains, ((PlainRelation)relation).domains)) {
            throw new RuntimeException(Messages.getString(PlainRelation.class.getName() + "-10"));
        }
        return this.root.equals(((PlainRelation)relation).root);
    }

    @Override
    public boolean contains(IRelation relation, ThreadCallback threadCallback) {
        if (!ArrayHelper.equals(this.domains, ((PlainRelation)relation).domains)) {
            throw new RuntimeException(Messages.getString(PlainRelation.class.getName() + "-11"));
        }
        return ((PlainRelation)relation).root.superset(this.root);
    }

    @Override
    public boolean isEmpty() {
        return this.root.isZero();
    }

    @Override
    public void kill() {
        if (!this.isPersistent) {
            this.isKilled = true;
            this.root.decRefCount();
        }
    }

    public void finalize() {
        if (this.bddManager.decRefCountOnGC() && !this.isKilled && this.bddSerialID == this.bddManager.getManagerSerialID()) {
            this.root.decRefCount();
        }
    }
}

