/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.repositories;

import com.jetbrains.sourceglider.domains.DomainType;
import com.jetbrains.sourceglider.relations.IRelation;
import com.jetbrains.sourceglider.repositories.RepositoryEvent;
import com.jetbrains.sourceglider.repositories.RepostoryActionListener;
import com.jetbrains.sourceglider.ui.Messages;
import com.jetbrains.sourceglider.ui.ThreadCallback;
import java.util.ArrayList;
import java.util.List;

public abstract class RelationsRepository {
    protected List<RepostoryActionListener> listeners = new ArrayList<RepostoryActionListener>();

    public abstract void clear();

    public abstract String[] getAvailableRelations();

    public abstract boolean containsRelation(String var1);

    public abstract IRelation getRelation(String var1);

    public abstract DomainType[] getDomainTypes(String var1);

    public void addListener(RepostoryActionListener listener2) {
        this.listeners.add(listener2);
    }

    public void deleteRelation(String name) {
        for (RepostoryActionListener listener2 : this.listeners) {
            listener2.relationRemoved(new RepositoryEvent(name, null, this.getClass()));
        }
    }

    public void deleteAllRelations(String[] names) {
        for (String name : names) {
            this.deleteRelation(name);
        }
    }

    public void addRelation(String name, IRelation relation) {
        for (RepostoryActionListener listener2 : this.listeners) {
            listener2.relationAdded(new RepositoryEvent(name, relation, this.getClass()));
        }
    }

    public void addAllRelations(RelationsRepository holder, ThreadCallback threadCallback) {
        this.addAllRelations(holder, holder.getAvailableRelations(), threadCallback);
    }

    public void addAllRelations(RelationsRepository holder, String[] names, ThreadCallback threadCallback) {
        for (int i2 = 0; i2 < names.length; ++i2) {
            if (threadCallback.checkCancelled()) {
                return;
            }
            threadCallback.informProgress(i2, names.length, Messages.getString(RelationsRepository.class.getName() + "-0") + names[i2]);
            this.addRelation(names[i2], holder.getRelation(names[i2]));
        }
    }
}

