/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.scripts;

import com.jetbrains.sourceglider.domains.DomainType;
import com.jetbrains.sourceglider.relations.RelationSignature;
import com.jetbrains.sourceglider.repositories.HypoteticRelationsRepository;
import com.jetbrains.sourceglider.ui.Messages;
import java.util.HashMap;

public class GenericDomainTypeUnifier {
    private HypoteticRelationsRepository holder;
    private HashMap<String, DomainType> map;
    private String scriptName;

    public GenericDomainTypeUnifier(HypoteticRelationsRepository holder) {
        this.holder = holder;
    }

    public String unifySignatures(RelationSignature[] signatures, String scriptName) {
        this.scriptName = scriptName;
        this.map = new HashMap();
        for (RelationSignature signature : signatures) {
            String genericRelation = signature.getName();
            if (!this.holder.containsRelation(genericRelation)) {
                return genericRelation;
            }
            DomainType[] trueTypes = this.holder.getDomainTypes(genericRelation);
            if (trueTypes.length != signature.getTypes().length) {
                throw new RuntimeException(Messages.getString(GenericDomainTypeUnifier.class.getName() + "-0") + genericRelation + Messages.getString(GenericDomainTypeUnifier.class.getName() + "-1") + scriptName + Messages.getString(GenericDomainTypeUnifier.class.getName() + "-2"));
            }
            for (int j = 0; j < trueTypes.length; ++j) {
                DomainType type2 = signature.getType(j);
                String genericType = type2.getName();
                if (type2.isGeneric()) {
                    if (this.map.containsKey(genericType)) {
                        if (this.map.get(genericType) == trueTypes[j]) continue;
                        throw new RuntimeException(Messages.getString(GenericDomainTypeUnifier.class.getName() + "-3") + genericRelation + Messages.getString(GenericDomainTypeUnifier.class.getName() + "-4") + scriptName + Messages.getString(GenericDomainTypeUnifier.class.getName() + "-5"));
                    }
                    this.map.put(genericType, trueTypes[j]);
                    continue;
                }
                if (type2 == trueTypes[j]) continue;
                throw new RuntimeException(Messages.getString(GenericDomainTypeUnifier.class.getName() + "-6") + genericRelation + Messages.getString(GenericDomainTypeUnifier.class.getName() + "-7") + scriptName + Messages.getString(GenericDomainTypeUnifier.class.getName() + "-8"));
            }
        }
        return null;
    }

    public DomainType instantiateGenericType(DomainType type2) {
        if (!type2.isGeneric()) {
            return type2;
        }
        if (!this.map.containsKey(type2.getName())) {
            throw new RuntimeException(Messages.getString(GenericDomainTypeUnifier.class.getName() + "-9") + type2.getName() + Messages.getString(GenericDomainTypeUnifier.class.getName() + "-10") + this.scriptName + "\"");
        }
        return this.map.get(type2.getName());
    }
}

