/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.scripts.rml;

import com.jetbrains.sourceglider.domains.Domain;
import com.jetbrains.sourceglider.domains.DomainType;
import com.jetbrains.sourceglider.relations.IRelation;
import com.jetbrains.sourceglider.relations.IRelationsManager;
import com.jetbrains.sourceglider.relations.RelationSignature;
import com.jetbrains.sourceglider.repositories.RelationsRepository;
import com.jetbrains.sourceglider.scripts.rml.parser.VariablesManager;
import com.jetbrains.sourceglider.ui.Messages;
import com.jetbrains.sourceglider.ui.ThreadCallback;
import java.util.HashMap;
import java.util.Map;

public class RuntimeVariablesManager {
    private RelationsRepository relationsRepository;
    private RelationSignature[] outputRelations;
    private HashMap<String, IRelation> relations = new HashMap();
    private HashMap<String, Domain> domains = new HashMap();
    private HashMap variables = new HashMap();

    public RuntimeVariablesManager(RelationsRepository relationsRepository, Map options, VariablesManager staticManager, IRelationsManager relationsManager) {
        this.relationsRepository = relationsRepository;
        this.outputRelations = staticManager.getOutputRelations();
        for (String name : staticManager.getVariables()) {
            if (staticManager.isOption(name)) {
                if (options.containsKey(name)) {
                    this.variables.put(name, options.get(name));
                    continue;
                }
                this.variables.put(name, staticManager.getDefaultOptionValue(name));
                continue;
            }
            this.variables.put(name, new Integer(0));
        }
        for (int i2 = 0; i2 < staticManager.getInputRelations().length; ++i2) {
            String name;
            name = staticManager.getInputRelations()[i2].getName();
            IRelation relation = relationsRepository.getRelation(name);
            if (relation == null) {
                throw new RuntimeException(Messages.getString(RuntimeVariablesManager.class.getName() + "-0") + name + "\"");
            }
            this.relations.put(name, relation);
        }
        for (RelationSignature outputRelation : this.outputRelations) {
            String name = outputRelation.getName();
            if (this.relations.containsKey(name)) continue;
            IRelation relation = relationsManager.makeEmptyRelation(staticManager.getRelation(name));
            this.relations.put(name, relation);
        }
        for (int i3 = 0; i3 < staticManager.getTempRelations().length; ++i3) {
            String name = staticManager.getTempRelations()[i3].getName();
            if (this.relations.containsKey(name)) continue;
            IRelation relation = relationsManager.makeEmptyRelation(staticManager.getRelation(name));
            this.relations.put(name, relation);
        }
    }

    public void storeOutputRelations(ThreadCallback threadCallback) {
        for (RelationSignature outputRelation : this.outputRelations) {
            String name = outputRelation.getName();
            IRelation relation = this.relations.get(name);
            relation = relation.fastRename(DomainType.getCorrespondingDomains(relation.getDomainTypes()), threadCallback);
            this.relationsRepository.addRelation(name, relation);
        }
    }

    public IRelation getRelation(String name) {
        return this.relations.get(name);
    }

    public void storeRelation(String name, IRelation relation) {
        this.relations.put(name, relation);
    }

    public int getVariable(String name) {
        return (Integer)this.variables.get(name);
    }

    public void storeVariable(String name, int value2) {
        this.variables.put(name, new Integer(value2));
    }

    public Domain getDomain(String name) {
        return this.domains.get(name);
    }

    public void storeDomain(String name, Domain domain) {
        this.domains.put(name, domain);
    }

    public void removeDomain(String name) {
        this.domains.remove(name);
    }
}

