/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.scripts.rml.ast;

import com.jetbrains.sourceglider.domains.Domain;
import com.jetbrains.sourceglider.relations.IRelation;
import com.jetbrains.sourceglider.relations.IRelationsManager;
import com.jetbrains.sourceglider.scripts.rml.DomainsPool;
import com.jetbrains.sourceglider.scripts.rml.ProfileManager;
import com.jetbrains.sourceglider.scripts.rml.RuntimeVariablesManager;
import com.jetbrains.sourceglider.scripts.rml.ast.Stmt;
import com.jetbrains.sourceglider.scripts.rml.parser.Context;
import com.jetbrains.sourceglider.symtable.SymbolTable;
import com.jetbrains.sourceglider.ui.ThreadCallback;
import com.jetbrains.sourceglider.ui.UIInstancesProvider;
import com.jetbrains.sourceglider.utils.ArrayHelper;
import java.util.List;

public class StmtIncrementalize
extends Stmt {
    private Stmt header;
    private Stmt loop;
    private String[] relations;

    public StmtIncrementalize(List<String> relsList, Stmt header, Stmt loop, Context context) {
        super(context);
        this.header = header;
        this.loop = loop;
        this.relations = ArrayHelper.castStringArray(relsList.toArray());
    }

    @Override
    public void interpret(IRelationsManager relationsManager, RuntimeVariablesManager variablesManager, ThreadCallback threadCallback, DomainsPool domainsPool, UIInstancesProvider uiInstancesProvider, SymbolTable symbolTable, ProfileManager profileManager) {
        boolean isEmpty;
        if (threadCallback.checkCancelled()) {
            return;
        }
        IRelation[] results = new IRelation[this.relations.length];
        Domain[][] domains = new Domain[this.relations.length][];
        for (int i2 = 0; i2 < this.relations.length; ++i2) {
            String relation = this.relations[i2];
            domains[i2] = variablesManager.getRelation(relation).getDomains();
            results[i2] = relationsManager.makeRepositoryRelation(variablesManager.getRelation(relation), relation);
        }
        this.header.interpret(relationsManager, variablesManager, threadCallback, domainsPool, uiInstancesProvider, symbolTable, profileManager);
        do {
            IRelation work;
            int i3;
            if (threadCallback.checkCancelled()) {
                return;
            }
            for (i3 = 0; i3 < this.relations.length; ++i3) {
                work = relationsManager.makeRepositoryRelation(variablesManager.getRelation(this.relations[i3]), "0" + this.toString());
                work = work.fastRename(domains[i3], threadCallback);
                IRelation oldResult = results[i3];
                results[i3] = results[i3].unite(work, threadCallback);
                oldResult.kill();
                work.kill();
            }
            this.loop.interpret(relationsManager, variablesManager, threadCallback, domainsPool, uiInstancesProvider, symbolTable, profileManager);
            for (i3 = 0; i3 < this.relations.length; ++i3) {
                work = relationsManager.makeRepositoryRelation(variablesManager.getRelation(this.relations[i3]), "1" + this.toString());
                work = work.fastRename(domains[i3], threadCallback);
                variablesManager.storeRelation(this.relations[i3], work.subtract(results[i3], threadCallback));
                work.kill();
            }
            isEmpty = true;
            for (String relation : this.relations) {
                isEmpty &= variablesManager.getRelation(relation).isEmpty();
            }
        } while (!isEmpty);
        for (int i4 = 0; i4 < this.relations.length; ++i4) {
            variablesManager.storeRelation(this.relations[i4], results[i4]);
        }
    }
}

