/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.scripts.rml.ast;

import com.jetbrains.sourceglider.domains.Domain;
import com.jetbrains.sourceglider.domains.DomainType;
import com.jetbrains.sourceglider.relations.IRelation;
import com.jetbrains.sourceglider.relations.IRelationsManager;
import com.jetbrains.sourceglider.scripts.rml.DomainConstraint;
import com.jetbrains.sourceglider.scripts.rml.DomainsPool;
import com.jetbrains.sourceglider.scripts.rml.ProfileManager;
import com.jetbrains.sourceglider.scripts.rml.RuntimeVariablesManager;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExpr;
import com.jetbrains.sourceglider.scripts.rml.ast.Stmt;
import com.jetbrains.sourceglider.scripts.rml.parser.Context;
import com.jetbrains.sourceglider.symtable.SymbolTable;
import com.jetbrains.sourceglider.ui.ThreadCallback;
import com.jetbrains.sourceglider.ui.UIInstancesProvider;
import com.jetbrains.sourceglider.utils.ArrayHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class StmtRelAssign
extends Stmt {
    private String relname;
    private String[] names;
    private DomainConstraint[][] domainConstraints;
    private RelExpr expr;

    public StmtRelAssign(String relname, String[] names, RelExpr expr, Context context) {
        super(context);
        int i2;
        this.relname = relname;
        this.names = names;
        this.expr = expr;
        this.domainConstraints = new DomainConstraint[names.length][];
        HashMap<String, List> constraintsMap = new HashMap<String, List>();
        ArrayList[] vectors = new ArrayList[names.length];
        for (i2 = 0; i2 < vectors.length; ++i2) {
            vectors[i2] = new ArrayList();
            constraintsMap.put(names[i2], vectors[i2]);
        }
        expr.collectDomainConstraints(constraintsMap, context.variablesManager);
        for (i2 = 0; i2 < vectors.length; ++i2) {
            this.domainConstraints[i2] = (DomainConstraint[])ArrayHelper.castArray(vectors[i2].toArray(), DomainConstraint.class);
        }
    }

    @Override
    public void interpret(IRelationsManager relationsManager, RuntimeVariablesManager variablesManager, ThreadCallback threadCallback, DomainsPool domainsPool, UIInstancesProvider uiInstancesProvider, SymbolTable symbolTable, ProfileManager profileManager) {
        if (threadCallback.checkCancelled()) {
            return;
        }
        IRelation relation = variablesManager.getRelation(this.relname);
        Domain[] domains = new Domain[this.names.length];
        for (int i2 = 0; i2 < this.names.length; ++i2) {
            Domain[] type2 = relation.getDomainType(i2);
            Domain domain = domainsPool.computeBestDomain(variablesManager, this.names[i2], (DomainType)type2, this.domainConstraints[i2]);
            domainsPool.pushDomain(domain);
            variablesManager.storeDomain(this.names[i2], domain);
            domains[i2] = domain;
        }
        IRelation result2 = this.expr.interpret(relationsManager, variablesManager, threadCallback, domainsPool, uiInstancesProvider, symbolTable, profileManager);
        for (Domain domain : domains) {
            domainsPool.popDomain(domain);
        }
        domainsPool.assertEmpty();
        IRelation oldResult = result2;
        result2 = result2.reorderDomains(domains);
        oldResult.kill();
        variablesManager.storeRelation(this.relname, result2);
    }
}

