/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.symtable;

import com.jetbrains.sourceglider.domains.DomainType;
import com.jetbrains.sourceglider.symtable.AttributeInfo;
import com.jetbrains.sourceglider.symtable.SingleDomainAttribute;
import com.jetbrains.sourceglider.symtable.SymbolTable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class MultiDomainAttribute
implements AttributeInfo,
Serializable {
    private static final long serialVersionUID = -5058984908897683457L;
    private List<SingleDomainAttribute> singles = new ArrayList<SingleDomainAttribute>(2);

    public MultiDomainAttribute(SingleDomainAttribute attr1, SingleDomainAttribute attr2) {
        this.singles.add(attr1);
        this.singles.add(attr2);
    }

    @Override
    public DomainType[] getAllowableDomainTypes(SymbolTable symbolTable) {
        DomainType[] types = new DomainType[this.singles.size()];
        for (int i2 = 0; i2 < types.length; ++i2) {
            types[i2] = this.singles.get(i2).getDomainType(symbolTable);
        }
        return types;
    }

    @Override
    public String[] getAllowableDomainTypeNames(SymbolTable symbolTable) {
        String[] types = new String[this.singles.size()];
        for (int i2 = 0; i2 < types.length; ++i2) {
            types[i2] = this.singles.get(i2).getDomainType(symbolTable).getName();
        }
        return types;
    }

    @Override
    public boolean allowsDomainType(DomainType type2, SymbolTable symbolTable) {
        for (SingleDomainAttribute single : this.singles) {
            if (single.getDomainType(symbolTable) != type2) continue;
            return true;
        }
        return false;
    }

    public MultiDomainAttribute addAttributeInfo(SingleDomainAttribute single) {
        this.singles.add(single);
        return this;
    }

    @Override
    public SingleDomainAttribute getAttributeInfo(DomainType type2, SymbolTable symbolTable) {
        for (SingleDomainAttribute single : this.singles) {
            SingleDomainAttribute attr = single;
            if (attr.getDomainType(symbolTable) != type2) continue;
            return attr;
        }
        return null;
    }

    @Override
    public int memorySize() {
        return 24 + this.singles.size() * 12;
    }
}

