/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.symtable;

import com.jetbrains.sourceglider.domains.DomainType;
import com.jetbrains.sourceglider.symtable.AttributeInfo;
import com.jetbrains.sourceglider.symtable.SymbolTable;
import java.io.Serializable;

public class SingleDomainAttribute
implements AttributeInfo,
Serializable {
    private static final long serialVersionUID = -578979401735959671L;
    String typeName;
    int index;

    public SingleDomainAttribute(DomainType domainType, int index) {
        this.typeName = domainType.getName();
        this.index = index;
    }

    public int hashCode() {
        return this.typeName.hashCode() * 31 + this.index;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SingleDomainAttribute)) {
            return false;
        }
        SingleDomainAttribute attr = (SingleDomainAttribute)obj;
        return this.typeName.equals(attr.typeName) && this.index == attr.index;
    }

    public DomainType getDomainType(SymbolTable symbolTable) {
        return symbolTable.getDomainType(this.typeName);
    }

    @Override
    public DomainType[] getAllowableDomainTypes(SymbolTable symbolTable) {
        return new DomainType[]{this.getDomainType(symbolTable)};
    }

    @Override
    public String[] getAllowableDomainTypeNames(SymbolTable symbolTable) {
        return new String[]{this.typeName};
    }

    @Override
    public boolean allowsDomainType(DomainType type2, SymbolTable symbolTable) {
        return type2.getName().equals(this.typeName);
    }

    @Override
    public SingleDomainAttribute getAttributeInfo(DomainType type2, SymbolTable symbolTable) {
        return this;
    }

    @Override
    public int memorySize() {
        return 12;
    }
}

