/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.ui;

import com.jetbrains.sourceglider.ui.Task;
import com.jetbrains.sourceglider.ui.ThreadCallback;
import com.jetbrains.sourceglider.ui.UICallback;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class ConsoleUI
implements UICallback {
    private static final int STATE_TASK_FINISHED_OK = 0;
    private static final int STATE_TASK_FINISHED_FAILED = 1;
    private static final int STATE_TASK_RUNNING = 2;
    private int taskState = 0;
    private boolean exitOnError;
    private ThreadCallback threadCallback = new ThreadCallback(){

        @Override
        public void informProgress(int completed, int total, String message2) {
            System.out.println(message2 + "... " + completed * 100 / total + "% completed");
        }

        @Override
        public void informProgress(String message2) {
            System.out.println(message2);
        }

        @Override
        public boolean checkCancelled() {
            return false;
        }
    };

    public ConsoleUI() {
    }

    public ConsoleUI(boolean exitOnError) {
        this.exitOnError = exitOnError;
    }

    @Override
    public void initCounterLimits() {
    }

    @Override
    public void resetCounters() {
    }

    @Override
    public boolean isWarningsDisabled() {
        return false;
    }

    @Override
    public boolean isErrorsDisabled() {
        return false;
    }

    @Override
    public void showMessage(String message2) {
        System.out.println("message>" + message2);
    }

    @Override
    public void showWarningMessage(String message2) {
        System.err.println("WARNING MESSAGE>" + message2);
        if (this.exitOnError) {
            System.exit(1);
        }
    }

    @Override
    public void showErrorMessage(String message2, boolean isFatal) {
        System.err.println("ERROR MESSAGE>" + message2);
        if (this.exitOnError) {
            System.exit(1);
        }
    }

    @Override
    public void showWarning(String message2) {
        System.err.println("WARNING>" + message2);
        if (this.exitOnError) {
            System.exit(1);
        }
    }

    @Override
    public void showWarning(String message2, Throwable exception) {
        System.err.println("WARNING>" + message2);
        exception.printStackTrace();
        if (this.exitOnError) {
            System.exit(1);
        }
    }

    @Override
    public void showError(String message2, Throwable exception, boolean isFatal) {
        System.err.println("ERROR>" + message2);
        exception.printStackTrace();
        if (this.exitOnError) {
            System.exit(1);
        }
    }

    @Override
    public void showError(String message2, boolean isFatal) {
        System.err.println("ERROR>" + message2);
        if (this.exitOnError) {
            System.exit(1);
        }
    }

    @Override
    public void showErrorWithMessage(String message2, boolean isFatal) {
        System.err.println("ERROR>" + message2);
        if (this.exitOnError) {
            System.exit(1);
        }
    }

    @Override
    public void showErrorMessageWithHelp(String message2, int helpContextNumber, boolean isFatal) {
        System.err.println("ERROR>" + message2);
        if (this.exitOnError) {
            System.exit(1);
        }
    }

    @Override
    public void showErrorWithMessage(String message2, Throwable exception, boolean isFatal) {
        System.err.println("ERROR>" + message2);
        exception.printStackTrace();
        if (this.exitOnError) {
            System.exit(1);
        }
    }

    @Override
    public void showException(Throwable e, boolean isFatal) {
        System.err.println("EXCEPTION>" + e.getMessage());
        e.printStackTrace();
        if (this.exitOnError) {
            System.exit(1);
        }
    }

    @Override
    public boolean askConfirm(String message2) {
        System.out.println("input>" + message2 + "[y/n]");
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            String line = reader.readLine();
            return line.toLowerCase().equals("y");
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int askConfirmWithCancel(String message2) {
        System.out.println("input>" + message2 + "[y/n/c]");
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            String line = reader.readLine();
            if (line.toLowerCase().equals("y")) {
                return 1;
            }
            if (line.toLowerCase().equals("n")) {
                return 0;
            }
            return -1;
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1;
        }
    }

    @Override
    public boolean askWarningConfirm(String message2) {
        System.out.println("WARNING>" + message2 + "[y/n]");
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            String line = reader.readLine();
            return line.toLowerCase().equals("y");
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean askWarningConfirm(String message2, String yesButtonCaption, String noButtonCaption) {
        System.out.println("WARNING>" + message2 + "[" + yesButtonCaption + "(y)/" + noButtonCaption + "(n)]");
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            String line = reader.readLine();
            return line.toLowerCase().equals("y");
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public String input(String message2, String defaultInput) {
        BufferedReader reader;
        System.out.println("input>" + message2 + ": ");
        if (defaultInput.length() != 0) {
            System.out.print(defaultInput + " [y/n]");
            try {
                reader = new BufferedReader(new InputStreamReader(System.in));
                String line = reader.readLine();
                if (line.toLowerCase().equals("y")) {
                    return defaultInput;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return "";
            }
        }
        try {
            reader = new BufferedReader(new InputStreamReader(System.in));
            return reader.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
            return defaultInput;
        }
    }

    public void runAsyncThread(Task task, boolean isSystem) {
        new Thread(() -> {
            try {
                this.taskState = 2;
                if (!isSystem) {
                    System.out.println(task.getName());
                }
                task.run(this.threadCallback);
                this.taskState = 0;
            }
            catch (Throwable e) {
                this.taskState = 1;
                this.showException(e, true);
            }
        }, "console ui").run();
    }

    @Override
    public void runAsyncThread(Task task) {
        this.runAsyncThread(task, false);
    }

    @Override
    public void runSystemThread(Task task) {
        this.runAsyncThread(task, true);
    }

    @Override
    public void runUIThread(Runnable buggyThread) {
        try {
            buggyThread.run();
        }
        catch (Throwable e) {
            this.showException(e, true);
        }
    }

    public void runAllAsyncThreads(final Task[] tasks, String groupName) {
        if (tasks == null) {
            return;
        }
        System.out.println(groupName);
        new Thread("console ui async"){

            @Override
            public void run() {
                try {
                    ConsoleUI.this.taskState = 2;
                    for (Task task : tasks) {
                        System.out.println(task.getName());
                        task.run(ConsoleUI.this.threadCallback);
                    }
                    ConsoleUI.this.taskState = 0;
                }
                catch (Throwable e) {
                    ConsoleUI.this.taskState = 1;
                    ConsoleUI.this.showException(e, true);
                }
            }
        }.run();
    }

    @Override
    public void startTimer(String id, int delay, Runnable task) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void killTimer(String id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isTaskRunning() {
        return this.taskState == 2;
    }

    @Override
    public Object[] getSelection(String caption, Object[] items) {
        throw new UnsupportedOperationException();
    }
}

