/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.ui;

import com.jetbrains.sourceglider.ui.IConfigs;
import com.jetbrains.sourceglider.ui.Messages;
import com.jetbrains.sourceglider.ui.UICallback;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class FileConfigs
implements IConfigs {
    private final UICallback uiCallback;
    private Properties properties;
    private String configsPath;

    public FileConfigs(String configsPath, UICallback callback) {
        this.configsPath = configsPath;
        this.properties = new Properties();
        this.uiCallback = callback;
    }

    @Override
    public String getValue(String key2, String defaultValue) {
        this.read();
        if (this.properties.containsKey(key2) && this.properties.getProperty(key2).length() > 0) {
            return this.properties.getProperty(key2);
        }
        if (defaultValue == null) {
            defaultValue = "";
        }
        this.properties.setProperty(key2, defaultValue);
        this.write();
        return defaultValue;
    }

    @Override
    public String getValue(String key2, String inputMessage, String defaultValue) {
        this.read();
        if (this.properties.containsKey(key2) && this.properties.getProperty(key2).length() > 0) {
            return this.properties.getProperty(key2);
        }
        if (defaultValue.length() == 0 || defaultValue == null) {
            defaultValue = this.uiCallback.input(inputMessage, defaultValue);
        }
        this.properties.setProperty(key2, defaultValue);
        this.write();
        return defaultValue;
    }

    @Override
    public int getIntValue(String key2, int defaultValue) {
        return Integer.parseInt(this.getValue(key2, Integer.toString(defaultValue)));
    }

    @Override
    public boolean getBooleanValue(String key2, boolean defaultValue) {
        return Boolean.valueOf(this.getValue(key2, Boolean.toString(defaultValue)));
    }

    @Override
    public void setValue(String key2, String value2) {
        this.properties.setProperty(key2, value2);
        this.write();
    }

    @Override
    public void setIntValue(String key2, int value2) {
        this.properties.setProperty(key2, Integer.toString(value2));
        this.write();
    }

    @Override
    public void setBooleanValue(String key2, boolean value2) {
        this.properties.setProperty(key2, Boolean.toString(value2));
        this.write();
    }

    private void read() {
        if (this.configsPath == null) {
            return;
        }
        try {
            File file2 = new File(this.configsPath);
            if (file2.exists()) {
                FileInputStream fis = new FileInputStream(file2);
                this.properties.clear();
                this.properties.load(fis);
                fis.close();
            }
        }
        catch (IOException e) {
            this.uiCallback.showError(Messages.getString(FileConfigs.class.getName() + "-0") + this.configsPath + "\"", e, false);
        }
    }

    private void write() {
        try {
            FileOutputStream fos = new FileOutputStream(new File(this.configsPath));
            this.properties.store(fos, null);
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            this.uiCallback.showError(Messages.getString(FileConfigs.class.getName() + "-1") + this.configsPath + "\"", e, false);
        }
    }
}

