/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.ui;

import com.jetbrains.sourceglider.ui.UICallback;
import com.jetbrains.sourceglider.utils.FileHelper;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;

public class Messages {
    private static Properties properties;

    public static boolean init(URL propertiesFileURL, UICallback uiCallback) {
        properties = new Properties();
        if (propertiesFileURL != null) {
            try {
                properties.load(propertiesFileURL.openStream());
            }
            catch (Throwable e) {
                uiCallback.showException(e, true);
                return false;
            }
        } else {
            uiCallback.showError("Failed to load messages file", true);
            return false;
        }
        return true;
    }

    public static String getString(String key2) {
        if (properties == null) {
            return '!' + key2 + '!';
        }
        if (properties.containsKey(key2)) {
            return properties.getProperty(key2);
        }
        return '!' + key2 + '!';
    }

    public static void addString(URL propertiesFileURL, String key2, String value2) throws IOException {
        String content = FileHelper.readTextFromStream(propertiesFileURL.openStream());
        FileHelper.writeTextToStream(new FileOutputStream(propertiesFileURL.getPath()), content + "\n" + key2 + " = " + value2);
    }
}

