/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.utils;

import com.jetbrains.sourceglider.atttributes.Attribute;
import com.jetbrains.sourceglider.domains.Domain;
import com.jetbrains.sourceglider.ui.Messages;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class ArrayHelper {
    public static Object[] castArray(Object[] array, Class type2) {
        Object[] result2 = (Object[])Array.newInstance(type2, array.length);
        System.arraycopy(array, 0, result2, 0, array.length);
        return result2;
    }

    public static String[] castStringArray(Object[] array) {
        String[] result2 = (String[])Array.newInstance(String.class, array.length);
        System.arraycopy(array, 0, result2, 0, array.length);
        return result2;
    }

    public static int[] castIntArray(Object[] array) {
        int[] result2 = new int[array.length];
        for (int i2 = 0; i2 < array.length; ++i2) {
            result2[i2] = (Integer)array[i2];
        }
        return result2;
    }

    public static Object[] toArray(Collection collection, Class type2) {
        Object[] array = collection.toArray();
        return ArrayHelper.castArray(array, type2);
    }

    public static int searchElement(Object[] array, Object element) {
        for (int i2 = 0; i2 < array.length; ++i2) {
            if (!array[i2].equals(element)) continue;
            return i2;
        }
        return -1;
    }

    public static boolean containsElement(Object[] array, Object element) {
        return ArrayHelper.searchElement(array, element) != -1;
    }

    public static boolean haveCommonElements(Object[] array1, Object[] array2) {
        for (Object anArray1 : array1) {
            for (Object anArray2 : array2) {
                if (!anArray1.equals(anArray2)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean haveSameElems(int[] array) {
        int[] copy = new int[array.length];
        System.arraycopy(array, 0, copy, 0, array.length);
        Arrays.sort(copy);
        for (int i2 = 0; i2 < copy.length - 1; ++i2) {
            if (copy[i2] != copy[i2 + 1]) continue;
            return true;
        }
        return false;
    }

    public static Object[][] removeColumn(Object[][] array, int index, Class<Attribute> clazz) {
        if (array.length == 0) {
            return array;
        }
        Object[][] result2 = (Object[][])Array.newInstance(clazz, array.length, array[0].length - 1);
        for (int i2 = 0; i2 < array.length; ++i2) {
            for (int j = 0; j < array[i2].length; ++j) {
                if (j < index) {
                    result2[i2][j] = array[i2][j];
                    continue;
                }
                if (j <= index) continue;
                result2[i2][j - 1] = array[i2][j];
            }
        }
        return result2;
    }

    public static Object[][] swapColumns(Object[][] array, int index1, int index2, Class<Attribute> clazz) {
        if (array.length == 0) {
            return array;
        }
        Object[][] result2 = (Object[][])Array.newInstance(clazz, array.length, array[0].length);
        for (int i2 = 0; i2 < array.length; ++i2) {
            System.arraycopy(array[i2], 0, result2[i2], 0, array[i2].length);
            result2[i2][index1] = array[i2][index2];
            result2[i2][index2] = array[i2][index1];
        }
        return result2;
    }

    public static Object[] deleteElement(Object[] array, int index, Class<Domain> type2) {
        Object[] result2 = (Object[])Array.newInstance(type2, array.length - 1);
        System.arraycopy(array, 0, result2, 0, index);
        System.arraycopy(array, index + 1, result2, index, array.length - index - 1);
        return result2;
    }

    public static Object[] deleteElement(Object[] array, Object element, Class type2) {
        Object[] result2 = (Object[])Array.newInstance(type2, array.length - 1);
        int index = ArrayHelper.searchElement(array, element);
        if (index == -1) {
            throw new IllegalArgumentException(Messages.getString(ArrayHelper.class.getName() + "-0"));
        }
        System.arraycopy(array, 0, result2, 0, index);
        System.arraycopy(array, index + 1, result2, index, array.length - index - 1);
        return result2;
    }

    public static Object[] mergeArrays(Object[] array1, Object[] array2, Class type2) {
        Object[] result2 = (Object[])Array.newInstance(type2, array1.length + array2.length);
        System.arraycopy(array1, 0, result2, 0, array1.length);
        System.arraycopy(array2, 0, result2, array1.length, array2.length);
        return result2;
    }

    public static Object[] uniteArrays(Object[] array1, Object[] array2, Class<Domain> type2) {
        HashSet<Object> set2 = new HashSet<Object>();
        Object[] cat = new Object[array1.length + array2.length];
        int len = 0;
        for (Object anArray1 : array1) {
            cat[len++] = anArray1;
            set2.add(anArray1);
        }
        for (Object anArray2 : array2) {
            if (set2.contains(anArray2)) continue;
            cat[len++] = anArray2;
        }
        Object[] result2 = (Object[])Array.newInstance(type2, len);
        System.arraycopy(cat, 0, result2, 0, len);
        return result2;
    }

    public static boolean setEqual(Object[] array1, Object[] array2) {
        HashSet set2 = new HashSet();
        Collections.addAll(set2, array1);
        for (Object anArray2 : array2) {
            if (!set2.contains(anArray2)) {
                return false;
            }
            set2.remove(anArray2);
        }
        for (Object anArray1 : array1) {
            if (!set2.contains(anArray1)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(Object[] array1, Object[] array2) {
        if (array1.length != array2.length) {
            return false;
        }
        for (int i2 = 0; i2 < array1.length; ++i2) {
            if (array1[i2].equals(array2[i2])) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(byte[] array1, byte[] array2, int length) {
        for (int i2 = 0; i2 < length; ++i2) {
            if (array1[i2] == array2[i2]) continue;
            return false;
        }
        return true;
    }

    public static Object[] getIthRow(Object[][] matrix, int row, Class clazz) {
        Object[] result2 = (Object[])Array.newInstance(clazz, matrix.length);
        for (int i2 = 0; i2 < matrix.length; ++i2) {
            result2[i2] = matrix[i2][row];
        }
        return result2;
    }

    public static List<Integer> getFirstRow(List matrix) {
        ArrayList<Integer> result2 = new ArrayList<Integer>();
        for (Object aMatrix : matrix) {
            result2.add(new Integer(((int[])aMatrix)[0]));
        }
        return result2;
    }

    public static Object[] getFirstRow(Object[][] matrix, Class clazz) {
        Object[] result2 = (Object[])Array.newInstance(clazz, matrix.length);
        for (int i2 = 0; i2 < matrix.length; ++i2) {
            result2[i2] = matrix[i2][0];
        }
        return result2;
    }

    public static int[] getFirstRow(int[][] matrix) {
        int[] result2 = new int[matrix.length];
        for (int i2 = 0; i2 < matrix.length; ++i2) {
            result2[i2] = matrix[i2][0];
        }
        return result2;
    }

    public static int[] resizeIntArray(int[] array, int length) {
        int[] newArray = new int[length];
        System.arraycopy(array, 0, newArray, 0, length);
        return newArray;
    }

    public static Object[] copyArray(Object[] array, Class clazz) {
        Object[] result2 = (Object[])Array.newInstance(clazz, array.length);
        System.arraycopy(array, 0, result2, 0, array.length);
        return result2;
    }

    public static Object[] flipArray(Object[] array, Class clazz) {
        Object[] result2 = (Object[])Array.newInstance(clazz, array.length);
        for (int i2 = 0; i2 < array.length; ++i2) {
            result2[i2] = array[array.length - 1 - i2];
        }
        return result2;
    }
}

