/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.utils;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.math.BigInteger;
import java.nio.channels.FileChannel;
import java.util.ArrayList;

public class FileHelper {
    public static boolean exists(String filePath) {
        return new File(filePath).exists();
    }

    public static String readTextFromStream(InputStream stream) throws IOException {
        String line;
        BufferedReader buf = new BufferedReader(new InputStreamReader(stream));
        StringBuilder buffer = new StringBuilder();
        boolean first = true;
        do {
            if ((line = buf.readLine()) == null) continue;
            if (!first) {
                buffer.append("\r\n");
            }
            first = false;
            buffer.append(line);
        } while (line != null);
        stream.close();
        buf.close();
        return buffer.toString();
    }

    public static void writeTextToStream(OutputStream stream, String content) throws IOException {
        String line;
        PrintStream printStream = new PrintStream(new BufferedOutputStream(stream));
        BufferedReader buf = new BufferedReader(new StringReader(content));
        boolean first = true;
        do {
            if ((line = buf.readLine()) == null) continue;
            if (!first) {
                printStream.println();
            }
            first = false;
            printStream.print(line);
        } while (line != null);
        printStream.flush();
        printStream.close();
    }

    public static BigInteger readBigIntFromStream(InputStream stream) throws IOException {
        int length = (stream.read() << 8) + stream.read();
        BigInteger result2 = BigInteger.ZERO;
        for (int i2 = 0; i2 < length; ++i2) {
            result2 = result2.shiftLeft(8).add(BigInteger.valueOf(stream.read()));
        }
        return result2;
    }

    public static void writeBigIntToStream(OutputStream stream, BigInteger number) throws IOException {
        ArrayList<Integer> buffer = new ArrayList<Integer>();
        while (!number.equals(BigInteger.ZERO)) {
            buffer.add(new Integer(number.mod(BigInteger.valueOf(256L)).intValue()));
            number = number.shiftRight(8);
        }
        int length = buffer.size();
        stream.write((byte)(length >> 8));
        stream.write((byte)(length & 0xFF));
        for (int i2 = 0; i2 < length; ++i2) {
            stream.write((Integer)buffer.get(length - i2 - 1));
        }
    }

    public static long getFileTimestamp(String filePath) {
        return new File(filePath).lastModified();
    }

    public static long getSize(String filePath) throws IOException {
        return new FileInputStream(filePath).getChannel().size();
    }

    public static void copy(String srcPath, String dstPath) throws IOException {
        FileChannel srcChannel = new FileInputStream(srcPath).getChannel();
        FileChannel dstChannel = new FileOutputStream(dstPath).getChannel();
        srcChannel.transferTo(0L, srcChannel.size(), dstChannel);
        srcChannel.close();
        dstChannel.close();
    }

    public static boolean move(String srcPath, String dstPath) {
        return new File(srcPath).renameTo(new File(dstPath));
    }

    public static boolean delete(File file2) {
        if (!file2.delete()) {
            String dir = System.getProperty("java.io.tmpdir");
            if (dir != null) {
                return file2.renameTo(new File(dir + File.separator + file2.getName()));
            }
            return false;
        }
        return true;
    }
}

