/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.utils;

import com.jetbrains.sourceglider.ui.Messages;
import java.util.Calendar;

public class Formatter {
    public static String formatSize(long size) {
        if (size < 1024L) {
            return String.valueOf(size);
        }
        if ((size >>= 10) < 1024L) {
            return size + " K";
        }
        long intPart = size >> 10;
        long fracPart = size % 1024L / 103L;
        if (fracPart == 0L) {
            return intPart + " M";
        }
        return intPart + "." + fracPart + " M";
    }

    public static String formatTime(int milliSeconds) {
        int days;
        int seconds = milliSeconds / 1000;
        int secondsFrac = milliSeconds % 1000 / 100;
        int minutes = seconds / 60;
        int hours = minutes / 60;
        String result2 = (minutes %= 60) + (hours %= 24) + (days = hours / 24) > 0 ? minutes + " min " + seconds + Messages.getString(Formatter.class.getName() + "-1") : (seconds %= 60) + "." + secondsFrac + Messages.getString(Formatter.class.getName() + "-2");
        if (hours + days > 0) {
            result2 = hours + Messages.getString(Formatter.class.getName() + "-3") + result2;
        }
        if (days > 0) {
            result2 = days + Messages.getString(Formatter.class.getName() + "-4") + result2;
        }
        return result2;
    }

    public static String formatDate(long timestamp) {
        if (timestamp <= 0L) {
            return Messages.getString(Formatter.class.getName() + "-5");
        }
        Calendar calendar = (Calendar)Calendar.getInstance().clone();
        calendar.setTimeInMillis(timestamp);
        return Formatter.format2DigitString(calendar.get(2) + 1) + "." + Formatter.format2DigitString(calendar.get(5)) + "." + Formatter.format2DigitString(calendar.get(1)) + " " + Formatter.format2DigitString(calendar.get(11)) + ":" + Formatter.format2DigitString(calendar.get(12));
    }

    public static String formatDate(Calendar date) {
        String[] monthNames = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
        return date.get(5) + " " + monthNames[date.get(2)] + " " + date.get(1);
    }

    private static String format2DigitString(int value2) {
        return value2 < 10 ? "0" + value2 : String.valueOf(value2);
    }

    public static String formatApproximateTime(int milliSeconds) {
        int seconds = milliSeconds / 1000;
        int secondsFrac = milliSeconds % 1000 / 100;
        int minutes = seconds / 60;
        seconds %= 60;
        int hours = minutes / 60;
        minutes %= 60;
        int days = hours / 24;
        hours %= 24;
        if (days > 0) {
            return "~" + days + Messages.getString(Formatter.class.getName() + "-6");
        }
        if (hours > 0) {
            return "~" + hours + Messages.getString(Formatter.class.getName() + "-7");
        }
        if (minutes > 0) {
            return "~" + minutes + Messages.getString(Formatter.class.getName() + "-8");
        }
        if (seconds > 0) {
            return "~" + seconds + Messages.getString(Formatter.class.getName() + "-9");
        }
        return "~0." + secondsFrac + Messages.getString(Formatter.class.getName() + "-10");
    }

    private static long getApproxInt(long value2) {
        if (value2 < 100L) {
            return value2;
        }
        if (value2 % 10L < 5L) {
            return value2 - value2 % 10L;
        }
        return value2 + 10L - value2 % 10L;
    }

    public static String formatApproximateSize(long size) {
        if (size < 1024L) {
            return "~" + Formatter.getApproxInt(size);
        }
        if ((size >>= 10) < 1024L) {
            return "~" + Formatter.getApproxInt(size) + " K";
        }
        if ((size >>= 10) < 1024L) {
            return "~" + Formatter.getApproxInt(size) + " M";
        }
        long fracPart = size % 1024L / 103L;
        if ((size >>= 10) < 10L) {
            return "~" + size + "." + fracPart + " G";
        }
        return "~" + Formatter.getApproxInt(size) + " G";
    }
}

