/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.utils;

import com.jetbrains.sourceglider.ui.Messages;
import com.jetbrains.sourceglider.utils.ArrayHelper;
import com.jetbrains.sourceglider.utils.PrettyName;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class StringHelper {
    private static final int MAX_STRING_SURRONDINGS_LENGTH = 100;

    public static String makeCommaList(String[] values) {
        String result2 = "";
        if (values.length > 0) {
            result2 = values[0];
        }
        for (int i2 = 1; i2 < values.length; ++i2) {
            result2 = result2 + ", " + values[i2];
        }
        return result2;
    }

    public static String makeNewlineList(String[] values) {
        String result2 = "";
        for (String value2 : values) {
            result2 = result2 + "\n\t" + value2;
        }
        return result2;
    }

    public static String makeNewlineMap(Map map2, int linesCntLimit, int maxCharLength) {
        String result2 = "";
        Iterator itr = map2.keySet().iterator();
        for (int index = 0; itr.hasNext() && index < linesCntLimit; ++index) {
            Object key2 = itr.next();
            String keyStr = key2.toString();
            keyStr = keyStr.length() > maxCharLength ? "..." + keyStr.substring(keyStr.length() - maxCharLength - 3) : keyStr;
            result2 = result2 + "\n\t" + keyStr + " [" + map2.get(key2) + "]";
        }
        if (itr.hasNext()) {
            result2 = result2 + Messages.getString(StringHelper.class.getName() + "-0");
        }
        return result2;
    }

    public static String makeCommaList(Collection<String> coll) {
        return StringHelper.makeCommaList(ArrayHelper.castStringArray(coll.toArray()));
    }

    public static String getPrettyFirstLine(String string) {
        int pos1 = string.indexOf(13);
        int pos2 = string.indexOf(10);
        int pos = -1;
        if (pos1 != -1 && pos2 != -1) {
            pos = Math.min(pos1, pos2);
        } else if (pos1 != -1) {
            pos = pos1;
        } else if (pos2 != -1) {
            pos = pos2;
        }
        if (pos == -1) {
            return string;
        }
        return string.substring(0, pos) + "...";
    }

    public static int occurencesCnt(String string, String substr) {
        int pos = 0;
        int result2 = 0;
        while (pos != -1) {
            if ((pos = string.indexOf(substr, pos)) == -1) continue;
            pos += substr.length();
            ++result2;
        }
        return result2;
    }

    public static String getIdentifierName(String string) {
        StringBuilder result2 = new StringBuilder();
        boolean wasIDSymb = false;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char curSymbol = string.charAt(i2);
            if (Character.isLetterOrDigit(curSymbol) || curSymbol == '_') {
                if (!wasIDSymb && Character.isLowerCase(curSymbol)) {
                    result2.append((char)(curSymbol - 97 + 65));
                } else {
                    result2.append(curSymbol);
                }
                wasIDSymb = true;
                continue;
            }
            wasIDSymb = false;
        }
        return result2.toString();
    }

    public static PrettyName getStringSurroundings(String container, int start, int length, int linesBefore, int linesAfter) {
        String result2;
        int i2;
        if (start == -1) {
            return new PrettyName(Messages.getString(StringHelper.class.getName() + "-1"));
        }
        int lineStart = start + 1;
        int lineEnd = start - 1;
        int newlinesInMarked = 0;
        for (i2 = 0; i2 <= linesBefore; ++i2) {
            if (lineStart > 0 && container.charAt(lineStart - 1) == '\r' && container.charAt(lineStart) == '\n') {
                --lineStart;
            }
            if (lineStart == -1) continue;
            lineStart = Math.max(container.lastIndexOf(13, lineStart - 1), container.lastIndexOf(10, lineStart - 1));
        }
        for (i2 = 0; i2 <= linesAfter; ++i2) {
            if (lineEnd != -1) {
                if (container.charAt(lineEnd) == '\r' || lineEnd < container.length() - 1 && container.charAt(lineEnd + 1) == '\n') {
                    ++lineEnd;
                }
                int pos1 = container.indexOf(13, lineEnd + 1);
                int pos2 = container.indexOf(10, lineEnd + 1);
                lineEnd = pos1 == -1 ? pos2 : (pos2 == -1 ? pos1 : Math.min(pos1, pos2));
            }
            if (lineEnd == -1 || lineEnd >= start + length) continue;
            ++newlinesInMarked;
        }
        ++lineStart;
        if (lineEnd == -1) {
            lineEnd = container.length();
        }
        if (container.charAt(lineEnd - 1) == '\r') {
            --lineEnd;
        }
        if (linesBefore + linesAfter == 0) {
            if (start - lineStart > 100) {
                lineStart = start - 100;
            }
            if (lineEnd - (start + length) > 100) {
                lineEnd = start + length + 100;
            }
            while (lineStart < lineEnd && container.charAt(lineStart) <= ' ') {
                ++lineStart;
            }
            while (lineStart < lineEnd && container.charAt(lineEnd - 1) <= ' ') {
                --lineEnd;
            }
            if (lineStart > lineEnd) {
                int t = lineStart;
                lineStart = lineEnd;
                lineEnd = t;
            }
            result2 = container.substring(lineStart, lineEnd);
        } else {
            result2 = container.substring(lineStart, lineEnd);
            String[] delims = new String[]{" ", "\t"};
            boolean reducing = true;
            while (reducing) {
                reducing = false;
                for (String delim : delims) {
                    if (!result2.startsWith(delim) || StringHelper.occurencesCnt(result2, "\n" + delim) != linesBefore + linesAfter) continue;
                    result2 = result2.substring(1).replaceAll("\n" + delim, "\n");
                    start -= linesBefore + 1;
                    length -= newlinesInMarked;
                    lineEnd -= linesBefore + linesAfter + 1;
                    reducing = true;
                }
            }
        }
        if (start + length <= lineEnd) {
            return new PrettyName(result2, start - lineStart, start - lineStart + length);
        }
        return new PrettyName(result2 + "...", start - lineStart);
    }

    public static PrettyName surroundPrettyName(PrettyName prettyName, String before, String after2) {
        String newText = prettyName.getPrefix() + before + prettyName.getMarked() + after2 + prettyName.getSuffix();
        return new PrettyName(newText, prettyName.getMarkStart(), prettyName.getMarkEnd() + before.length() + after2.length());
    }

    public static boolean startsWith(String string, String prefix) {
        if (prefix.length() > string.length()) {
            return false;
        }
        for (int i2 = prefix.length() - 1; i2 >= 0; --i2) {
            if (string.charAt(i2) == prefix.charAt(i2)) continue;
            return false;
        }
        return true;
    }

    public static String applyCaesarCipher(String string, int shift) {
        StringBuilder result2 = new StringBuilder();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            result2.append((char)(string.charAt(i2) + shift));
        }
        return result2.toString();
    }

    public static String readVersionString(String string, int pos) {
        StringBuilder result2 = new StringBuilder();
        while (pos < string.length() && Character.isWhitespace(string.charAt(pos))) {
            ++pos;
        }
        if (pos < string.length() && Character.isDigit(string.charAt(pos))) {
            while (pos < string.length() && (Character.isDigit(string.charAt(pos)) || string.charAt(pos) == '.')) {
                result2.append(string.charAt(pos));
                ++pos;
            }
        }
        return result2.toString();
    }

    public static String removeSpaces(String string) {
        StringBuilder result2 = new StringBuilder();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (Character.isWhitespace(string.charAt(i2))) continue;
            result2.append(string.charAt(i2));
        }
        return result2.toString();
    }
}

