/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.visitors.filters;

import com.jetbrains.sourceglider.utils.ArrayHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ThreadFilters {
    private List<MethodThread> methodThreads = new ArrayList<MethodThread>();
    private Map<String, ThreadSwitch> methodToInvocationThread = new HashMap<String, ThreadSwitch>();
    private Map<String, UserThread> typeToUserThread = new HashMap<String, UserThread>();
    private Set<String> threads = new HashSet<String>();
    private Set<String> signatures = new HashSet<String>();

    public void addMethodThread(MethodThread methodThread) {
        this.methodThreads.add(methodThread);
        this.threads.add(methodThread.thread);
    }

    public void addThreadSwitch(ThreadSwitch invocationThread) {
        this.methodToInvocationThread.put(invocationThread.switchSignature, invocationThread);
        this.threads.add(invocationThread.thread);
        this.signatures.add(invocationThread.switchSignature);
        this.signatures.add(invocationThread.threadMethodStartSignature);
    }

    public void addUserThread(UserThread userThread) {
        this.typeToUserThread.put(userThread.type, userThread);
        this.signatures.add(userThread.signature);
    }

    public String[] getThreads() {
        return ArrayHelper.castStringArray(this.threads.toArray());
    }

    public String[] getSignatures() {
        return ArrayHelper.castStringArray(this.signatures.toArray());
    }

    public MethodThread[] getMethodThreads() {
        return (MethodThread[])ArrayHelper.castArray(this.methodThreads.toArray(), MethodThread.class);
    }

    public ThreadSwitch findInvocationThread(String signature) {
        return this.methodToInvocationThread.get(signature);
    }

    public UserThread getUserThread(String type2) {
        return this.typeToUserThread.get(type2);
    }

    public static class UserThread {
        public String type;
        public String signature;

        public UserThread(String type2, String signature) {
            this.type = type2;
            this.signature = signature;
        }
    }

    public static class ThreadSwitch {
        public String switchSignature;
        public String thread;
        public String threadMethodStartSignature;
        public int paramIndex;

        public ThreadSwitch(String switchSignature, String thread, String threadMethodStartSignature, int paramIndex) {
            this.switchSignature = switchSignature;
            this.thread = thread;
            this.threadMethodStartSignature = threadMethodStartSignature;
            this.paramIndex = paramIndex;
        }
    }

    public static class MethodThread {
        public String packagePrefix;
        public String thread;

        public MethodThread(String packagePrefix, String thread) {
            this.packagePrefix = packagePrefix;
            this.thread = thread;
        }
    }
}

