/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.TextRange;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;

public abstract class BaseInspectionVisitor
extends JavaElementVisitor {
    private BaseInspection inspection = null;
    private boolean onTheFly = false;
    private ProblemsHolder holder = null;

    final void setInspection(BaseInspection inspection) {
        this.inspection = inspection;
    }

    final void setOnTheFly(boolean onTheFly) {
        this.onTheFly = onTheFly;
    }

    public final boolean isOnTheFly() {
        return this.onTheFly;
    }

    protected final void registerNewExpressionError(@NotNull PsiNewExpression expression2, Object ... infos) {
        PsiJavaCodeReferenceElement classReference2 = expression2.getClassOrAnonymousClassReference();
        if (classReference2 == null) {
            this.registerError((PsiElement)expression2, infos);
        } else {
            this.registerError((PsiElement)classReference2, infos);
        }
    }

    protected final void registerMethodCallError(@NotNull PsiMethodCallExpression expression2, Object ... infos) {
        PsiReferenceExpression methodExpression = expression2.getMethodExpression();
        PsiElement nameToken = methodExpression.getReferenceNameElement();
        if (nameToken == null) {
            this.registerError((PsiElement)expression2, infos);
        } else {
            this.registerError(nameToken, infos);
        }
    }

    protected final void registerStatementError(@NotNull PsiStatement statement2, Object ... infos) {
        PsiElement statementToken = statement2.getFirstChild();
        if (statementToken == null) {
            this.registerError((PsiElement)statement2, infos);
        } else {
            this.registerError(statementToken, infos);
        }
    }

    protected final void registerClassError(@NotNull PsiClass aClass, Object ... infos) {
        PsiIdentifier nameIdentifier;
        if (aClass instanceof PsiEnumConstantInitializer) {
            PsiEnumConstantInitializer enumConstantInitializer = (PsiEnumConstantInitializer)aClass;
            PsiEnumConstant enumConstant = enumConstantInitializer.getEnumConstant();
            nameIdentifier = enumConstant.getNameIdentifier();
        } else if (aClass instanceof PsiAnonymousClass) {
            PsiAnonymousClass anonymousClass = (PsiAnonymousClass)aClass;
            nameIdentifier = anonymousClass.getBaseClassReference();
        } else {
            nameIdentifier = aClass.getNameIdentifier();
        }
        if (nameIdentifier == null) {
            this.registerError((PsiElement)aClass.getContainingFile(), infos);
        } else {
            this.registerError((PsiElement)nameIdentifier, infos);
        }
    }

    protected final void registerMethodError(@NotNull PsiMethod method2, Object ... infos) {
        PsiIdentifier nameIdentifier = method2.getNameIdentifier();
        if (nameIdentifier == null) {
            this.registerError((PsiElement)method2.getContainingFile(), infos);
        } else {
            this.registerError((PsiElement)nameIdentifier, infos);
        }
    }

    protected final void registerVariableError(@NotNull PsiVariable variable, Object ... infos) {
        PsiIdentifier nameIdentifier = variable.getNameIdentifier();
        if (nameIdentifier == null) {
            this.registerError((PsiElement)variable, infos);
        } else {
            this.registerError((PsiElement)nameIdentifier, infos);
        }
    }

    protected final void registerTypeParameterError(@NotNull PsiTypeParameter typeParameter, Object ... infos) {
        PsiIdentifier nameIdentifier = typeParameter.getNameIdentifier();
        if (nameIdentifier == null) {
            this.registerError((PsiElement)typeParameter, infos);
        } else {
            this.registerError((PsiElement)nameIdentifier, infos);
        }
    }

    protected final void registerFieldError(@NotNull PsiField field, Object ... infos) {
        PsiIdentifier nameIdentifier = field.getNameIdentifier();
        this.registerError((PsiElement)nameIdentifier, infos);
    }

    protected final void registerModifierError(@NotNull String modifier, @NotNull PsiModifierListOwner parameter, Object ... infos) {
        PsiElement[] children2;
        PsiModifierList modifiers = parameter.getModifierList();
        if (modifiers == null) {
            return;
        }
        for (PsiElement child : children2 = modifiers.getChildren()) {
            String text = child.getText();
            if (!modifier.equals(text)) continue;
            this.registerError(child, infos);
        }
    }

    protected final void registerClassInitializerError(@NotNull PsiClassInitializer initializer, Object ... infos) {
        PsiCodeBlock body2 = initializer.getBody();
        PsiJavaToken lBrace = body2.getLBrace();
        if (lBrace == null) {
            this.registerError((PsiElement)initializer, infos);
        } else {
            this.registerError((PsiElement)lBrace, infos);
        }
    }

    protected final void registerError(@NotNull PsiElement location, Object ... infos) {
        this.registerError(location, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, infos);
    }

    protected final void registerError(@NotNull PsiElement location, ProblemHighlightType highlightType, Object ... infos) {
        assert (location.getTextLength() != 0 || location instanceof PsiFile);
        LocalQuickFix[] fixes = this.createAndInitFixes(infos);
        String description = this.inspection.buildErrorString(infos);
        this.holder.registerProblem(location, description, highlightType, fixes);
    }

    protected final void registerErrorAtOffset(@NotNull PsiElement location, int offset, int length, Object ... infos) {
        this.registerErrorAtOffset(location, offset, length, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, infos);
    }

    protected final void registerErrorAtOffset(@NotNull PsiElement location, int offset, int length, ProblemHighlightType highlightType, Object ... infos) {
        assert (location.getTextLength() != 0 && length != 0);
        LocalQuickFix[] fixes = this.createAndInitFixes(infos);
        String description = this.inspection.buildErrorString(infos);
        TextRange range = new TextRange(offset, offset + length);
        this.holder.registerProblem(location, description, highlightType, range, fixes);
    }

    protected final void registerErrorAtRange(@NotNull PsiElement startLocation, @NotNull PsiElement endLocation, Object ... infos) {
        if (startLocation.getTextLength() == 0 && startLocation == endLocation) {
            return;
        }
        LocalQuickFix[] fixes = this.createAndInitFixes(infos);
        String description = this.inspection.buildErrorString(infos);
        ProblemDescriptor problemDescriptor = this.holder.getManager().createProblemDescriptor(startLocation, endLocation, description, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.onTheFly, fixes);
        this.holder.registerProblem(problemDescriptor);
    }

    @NotNull
    private LocalQuickFix[] createAndInitFixes(Object[] infos) {
        LocalQuickFix[] fixes;
        for (LocalQuickFix fix : fixes = this.createFixes(infos)) {
            fix.setOnTheFly(this.onTheFly);
        }
        return fixes;
    }

    @NotNull
    private InspectionGadgetsFix[] createFixes(Object ... infos) {
        if (!this.onTheFly && this.inspection.buildQuickFixesOnlyForOnTheFlyErrors()) {
            return InspectionGadgetsFix.EMPTY_ARRAY;
        }
        InspectionGadgetsFix[] fixes = this.inspection.buildFixes(infos);
        if (fixes.length > 0) {
            return fixes;
        }
        InspectionGadgetsFix fix = this.inspection.buildFix(infos);
        if (fix == null) {
            return InspectionGadgetsFix.EMPTY_ARRAY;
        }
        return new InspectionGadgetsFix[]{fix};
    }

    public void visitReferenceExpression(PsiReferenceExpression expression2) {
        this.visitExpression((PsiExpression)expression2);
    }

    public final void setProblemsHolder(ProblemsHolder holder) {
        this.holder = holder;
    }

    protected boolean isVisibleHighlight(@NotNull PsiElement element) {
        return !this.isOnTheFly() || !InspectionProjectProfileManager.isInformationLevel(this.inspection.getShortName(), element);
    }
}

