/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiReplacementUtil {
    private static final Logger LOG = Logger.getInstance((String)("#" + PsiReplacementUtil.class.getName()));

    public static void replaceExpression(@NotNull PsiExpression expression2, @NotNull @NonNls String newExpressionText) {
        Project project2 = expression2.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project2);
        PsiElementFactory factory = psiFacade.getElementFactory();
        PsiExpression newExpression = factory.createExpressionFromText(newExpressionText, (PsiElement)expression2);
        PsiElement replacementExpression = expression2.replace((PsiElement)newExpression);
        CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)project2);
        styleManager.reformat(replacementExpression);
    }

    public static PsiElement replaceExpressionAndShorten(@NotNull PsiExpression expression2, @NotNull @NonNls String newExpressionText) {
        Project project2 = expression2.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project2);
        PsiElementFactory factory = psiFacade.getElementFactory();
        PsiExpression newExpression = factory.createExpressionFromText(newExpressionText, (PsiElement)expression2);
        PsiElement replacementExp = expression2.replace((PsiElement)newExpression);
        JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)project2);
        javaCodeStyleManager.shortenClassReferences(replacementExp);
        CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)project2);
        return styleManager.reformat(replacementExp);
    }

    public static PsiElement replaceStatement(@NotNull PsiStatement statement2, @NotNull @NonNls String newStatementText) {
        Project project2 = statement2.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project2);
        PsiElementFactory factory = psiFacade.getElementFactory();
        PsiStatement newStatement = factory.createStatementFromText(newStatementText, (PsiElement)statement2);
        PsiElement replacementExp = statement2.replace((PsiElement)newStatement);
        CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)project2);
        return styleManager.reformat(replacementExp);
    }

    public static void replaceStatementAndShortenClassNames(@NotNull PsiStatement statement2, @NotNull @NonNls String newStatementText) {
        Project project2 = statement2.getProject();
        CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)project2);
        JavaCodeStyleManager javaStyleManager = JavaCodeStyleManager.getInstance((Project)project2);
        if (FileTypeUtils.isInServerPageFile((PsiElement)statement2)) {
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project2);
            PsiFile jspFile = PsiUtilCore.getTemplateLanguageFile((PsiElement)statement2);
            if (jspFile == null) {
                return;
            }
            Document document = documentManager.getDocument(jspFile);
            if (document == null) {
                return;
            }
            documentManager.doPostponedOperationsAndUnblockDocument(document);
            TextRange textRange = statement2.getTextRange();
            document.replaceString(textRange.getStartOffset(), textRange.getEndOffset(), (CharSequence)newStatementText);
            documentManager.commitDocument(document);
            FileViewProvider viewProvider = jspFile.getViewProvider();
            PsiElement elementAt = viewProvider.findElementAt(textRange.getStartOffset(), (Language)JavaLanguage.INSTANCE);
            if (elementAt == null) {
                return;
            }
            int endOffset = textRange.getStartOffset() + newStatementText.length();
            while (elementAt.getTextRange().getEndOffset() < endOffset || !(elementAt instanceof PsiStatement)) {
                if ((elementAt = elementAt.getParent()) != null) continue;
                LOG.error("Cannot decode statement");
                return;
            }
            PsiStatement newStatement = (PsiStatement)elementAt;
            javaStyleManager.shortenClassReferences((PsiElement)newStatement);
            TextRange newTextRange = newStatement.getTextRange();
            Language baseLanguage = viewProvider.getBaseLanguage();
            PsiFile element = viewProvider.getPsi(baseLanguage);
            if (element != null) {
                styleManager.reformatRange((PsiElement)element, newTextRange.getStartOffset(), newTextRange.getEndOffset());
            }
        } else {
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project2);
            PsiElementFactory factory = facade.getElementFactory();
            PsiStatement newStatement = factory.createStatementFromText(newStatementText, (PsiElement)statement2);
            newStatement = (PsiStatement)statement2.replace((PsiElement)newStatement);
            javaStyleManager.shortenClassReferences((PsiElement)newStatement);
            styleManager.reformat((PsiElement)newStatement);
        }
    }

    public static void replaceExpressionWithReferenceTo(@NotNull PsiExpression expression2, @NotNull PsiMember target) {
        Project project2 = expression2.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project2);
        PsiElementFactory factory = psiFacade.getElementFactory();
        PsiReferenceExpression newExpression = (PsiReferenceExpression)factory.createExpressionFromText("xxx", (PsiElement)expression2);
        PsiReferenceExpression replacementExpression = (PsiReferenceExpression)expression2.replace((PsiElement)newExpression);
        PsiElement element = replacementExpression.bindToElement((PsiElement)target);
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)project2);
        styleManager.shortenClassReferences(element);
    }

    @NotNull
    public static String getElementText(@NotNull PsiElement element, @Nullable PsiElement elementToReplace, @Nullable String replacement) {
        StringBuilder out = new StringBuilder();
        PsiReplacementUtil.getElementText(element, elementToReplace, replacement, out);
        return out.toString();
    }

    private static void getElementText(@NotNull PsiElement element, @Nullable PsiElement elementToReplace, @Nullable String replacement, @NotNull StringBuilder out) {
        if (element.equals(elementToReplace)) {
            out.append(replacement);
            return;
        }
        PsiElement[] children2 = element.getChildren();
        if (children2.length == 0) {
            out.append(element.getText());
            return;
        }
        for (PsiElement child : children2) {
            PsiReplacementUtil.getElementText(child, elementToReplace, replacement, out);
        }
    }

    public static void replaceOperatorAssignmentWithAssignmentExpression(@NotNull PsiAssignmentExpression assignmentExpression) {
        PsiJavaToken sign = assignmentExpression.getOperationSign();
        PsiExpression lhs = assignmentExpression.getLExpression();
        PsiExpression rhs = assignmentExpression.getRExpression();
        String operator2 = sign.getText();
        String newOperator = operator2.substring(0, operator2.length() - 1);
        String lhsText = lhs.getText();
        String rhsText = rhs == null ? "" : rhs.getText();
        boolean parentheses = ParenthesesUtils.areParenthesesNeeded(sign, rhs);
        String cast = PsiReplacementUtil.getCastString(lhs, rhs);
        StringBuilder newExpression = new StringBuilder(lhsText);
        newExpression.append('=').append(cast);
        if (!cast.isEmpty()) {
            newExpression.append('(');
        }
        newExpression.append(lhsText).append(newOperator);
        if (parentheses) {
            newExpression.append('(').append(rhsText).append(')');
        } else {
            newExpression.append(rhsText);
        }
        if (!cast.isEmpty()) {
            newExpression.append(')');
        }
        PsiReplacementUtil.replaceExpression((PsiExpression)assignmentExpression, newExpression.toString());
    }

    private static String getCastString(PsiExpression lhs, PsiExpression rhs) {
        if (lhs == null || rhs == null) {
            return "";
        }
        PsiType lType = lhs.getType();
        PsiType rType = rhs.getType();
        if (TypeConversionUtil.isNumericType((PsiType)rType)) {
            rType = TypeConversionUtil.binaryNumericPromotion((PsiType)lType, (PsiType)rType);
        }
        if (lType == null || rType == null || TypeConversionUtil.isAssignable((PsiType)lType, (PsiType)rType) || !TypeConversionUtil.areTypesConvertible((PsiType)lType, (PsiType)rType)) {
            return "";
        }
        return '(' + lType.getCanonicalText() + ')';
    }
}

