/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class InterfaceMethodClashesWithObjectInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("interface.clashes.with.object.class.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("interface.clashes.with.object.class.problem.descriptor", new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new InterfaceClashesWithObjectClassVisitor();
    }

    private static class InterfaceClashesWithObjectClassVisitor
    extends BaseInspectionVisitor {
        private InterfaceClashesWithObjectClassVisitor() {
        }

        public void visitMethod(PsiMethod method2) {
            super.visitMethod(method2);
            if (method2.getParameterList().getParametersCount() != 0) {
                return;
            }
            PsiClass aClass = method2.getContainingClass();
            if (aClass == null || !aClass.isInterface()) {
                return;
            }
            String name = method2.getName();
            if ("clone".equals(name) && !(method2.getReturnType() instanceof PsiClassType)) {
                this.registerMethodError(method2, new Object[0]);
            } else if ("finalize".equals(name) && !PsiType.VOID.equals((Object)method2.getReturnType())) {
                this.registerMethodError(method2, new Object[0]);
            }
        }
    }
}

