/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiTypeElement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.abstraction.ConcreteClassUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class MethodReturnOfConcreteClassInspection
extends BaseInspection {
    public boolean ignoreAbstractClasses = false;

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("method.return.concrete.class.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("method.return.concrete.class.problem.descriptor", new Object[0]);
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("method.return.of.concrete.class.option", new Object[0]), (InspectionProfileEntry)this, "ignoreAbstractClasses");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MethodReturnOfConcreteClassVisitor();
    }

    private class MethodReturnOfConcreteClassVisitor
    extends BaseInspectionVisitor {
        private MethodReturnOfConcreteClassVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method2) {
            super.visitMethod(method2);
            if (method2.isConstructor()) {
                return;
            }
            PsiTypeElement typeElement = method2.getReturnTypeElement();
            if (typeElement == null) {
                return;
            }
            if (!ConcreteClassUtil.typeIsConcreteClass(typeElement, MethodReturnOfConcreteClassInspection.this.ignoreAbstractClasses)) {
                return;
            }
            this.registerError((PsiElement)typeElement, new Object[0]);
        }
    }
}

