/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.WeakestTypeFinder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeMayBeWeakenedInspection
extends BaseInspection {
    public boolean useRighthandTypeAsWeakestTypeInAssignments = true;
    public boolean useParameterizedTypeForCollectionMethods = true;
    public boolean doNotWeakenToJavaLangObject = true;
    public boolean onlyWeakentoInterface = true;

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("type.may.be.weakened.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        Object info;
        Iterable weakerClasses = (Iterable)infos[1];
        StringBuilder builder = new StringBuilder();
        Iterator iterator = weakerClasses.iterator();
        if (iterator.hasNext()) {
            builder.append('\'').append(TypeMayBeWeakenedInspection.getClassName((PsiClass)iterator.next())).append('\'');
            while (iterator.hasNext()) {
                builder.append(", '").append(TypeMayBeWeakenedInspection.getClassName((PsiClass)iterator.next())).append('\'');
            }
        }
        if ((info = infos[0]) instanceof PsiField) {
            return InspectionGadgetsBundle.message("type.may.be.weakened.field.problem.descriptor", builder.toString());
        }
        if (info instanceof PsiParameter) {
            return InspectionGadgetsBundle.message("type.may.be.weakened.parameter.problem.descriptor", builder.toString());
        }
        if (info instanceof PsiMethod) {
            return InspectionGadgetsBundle.message("type.may.be.weakened.method.problem.descriptor", builder.toString());
        }
        return InspectionGadgetsBundle.message("type.may.be.weakened.problem.descriptor", builder.toString());
    }

    private static String getClassName(PsiClass aClass) {
        String qualifiedName = aClass.getQualifiedName();
        if (qualifiedName == null) {
            return aClass.getName();
        }
        return qualifiedName;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("type.may.be.weakened.ignore.option", new Object[0]), "useRighthandTypeAsWeakestTypeInAssignments");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("type.may.be.weakened.collection.method.option", new Object[0]), "useParameterizedTypeForCollectionMethods");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("type.may.be.weakened.do.not.weaken.to.object.option", new Object[0]), "doNotWeakenToJavaLangObject");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("only.weaken.to.an.interface", new Object[0]), "onlyWeakentoInterface");
        return optionsPanel;
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        Iterable weakerClasses = (Iterable)infos[1];
        ArrayList<TypeMayBeWeakenedFix> fixes = new ArrayList<TypeMayBeWeakenedFix>();
        for (PsiClass weakestClass : weakerClasses) {
            String className = TypeMayBeWeakenedInspection.getClassName(weakestClass);
            if (className == null) continue;
            fixes.add(new TypeMayBeWeakenedFix(className));
        }
        return fixes.toArray(new InspectionGadgetsFix[fixes.size()]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TypeMayBeWeakenedVisitor();
    }

    private class TypeMayBeWeakenedVisitor
    extends BaseInspectionVisitor {
        private TypeMayBeWeakenedVisitor() {
        }

        public void visitVariable(PsiVariable variable) {
            PsiExpression initializer;
            PsiForeachStatement foreachStatement;
            PsiExpression iteratedValue2;
            PsiElement parent;
            super.visitVariable(variable);
            if (variable instanceof PsiParameter) {
                PsiParameter parameter = (PsiParameter)variable;
                PsiElement declarationScope = parameter.getDeclarationScope();
                if (declarationScope instanceof PsiCatchSection) {
                    return;
                }
                if (declarationScope instanceof PsiLambdaExpression && parameter.getTypeElement() == null) {
                    return;
                }
                if (declarationScope instanceof PsiMethod) {
                    PsiMethod method2 = (PsiMethod)declarationScope;
                    PsiClass containingClass = method2.getContainingClass();
                    if (containingClass == null || containingClass.isInterface()) {
                        return;
                    }
                    if (JavaHighlightUtil.isSerializationRelatedMethod(method2, containingClass)) {
                        return;
                    }
                    if (MethodUtils.hasSuper(method2)) {
                        return;
                    }
                    Query overridingSearch = OverridingMethodsSearch.search((PsiMethod)method2);
                    if (overridingSearch.findFirst() != null) {
                        return;
                    }
                }
            }
            if (this.isOnTheFly() && variable instanceof PsiField && !variable.hasModifierProperty("private")) {
                return;
            }
            if (TypeMayBeWeakenedInspection.this.useRighthandTypeAsWeakestTypeInAssignments && (variable instanceof PsiParameter ? (parent = variable.getParent()) instanceof PsiForeachStatement && !((iteratedValue2 = (foreachStatement = (PsiForeachStatement)parent).getIteratedValue()) instanceof PsiNewExpression) && !(iteratedValue2 instanceof PsiTypeCastExpression) : !((initializer = variable.getInitializer()) instanceof PsiNewExpression) && !(initializer instanceof PsiTypeCastExpression))) {
                return;
            }
            Collection<PsiClass> weakestClasses = WeakestTypeFinder.calculateWeakestClassesNecessary((PsiElement)variable, TypeMayBeWeakenedInspection.this.useRighthandTypeAsWeakestTypeInAssignments, TypeMayBeWeakenedInspection.this.useParameterizedTypeForCollectionMethods);
            if (TypeMayBeWeakenedInspection.this.doNotWeakenToJavaLangObject) {
                Project project2 = variable.getProject();
                JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project2);
                PsiClass javaLangObjectClass = facade.findClass("java.lang.Object", variable.getResolveScope());
                weakestClasses.remove(javaLangObjectClass);
            }
            if (TypeMayBeWeakenedInspection.this.onlyWeakentoInterface) {
                Iterator<PsiClass> iterator = weakestClasses.iterator();
                while (iterator.hasNext()) {
                    PsiClass weakestClass = iterator.next();
                    if (weakestClass.isInterface()) continue;
                    iterator.remove();
                }
            }
            if (weakestClasses.isEmpty()) {
                return;
            }
            this.registerVariableError(variable, variable, weakestClasses);
        }

        public void visitMethod(PsiMethod method2) {
            super.visitMethod(method2);
            if (this.isOnTheFly() && !method2.hasModifierProperty("private") && !ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            if (MethodUtils.hasSuper(method2)) {
                return;
            }
            Query overridingSearch = OverridingMethodsSearch.search((PsiMethod)method2);
            if (overridingSearch.findFirst() != null) {
                return;
            }
            Collection<PsiClass> weakestClasses = WeakestTypeFinder.calculateWeakestClassesNecessary((PsiElement)method2, TypeMayBeWeakenedInspection.this.useRighthandTypeAsWeakestTypeInAssignments, TypeMayBeWeakenedInspection.this.useParameterizedTypeForCollectionMethods);
            if (TypeMayBeWeakenedInspection.this.doNotWeakenToJavaLangObject) {
                Project project2 = method2.getProject();
                JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project2);
                PsiClass javaLangObjectClass = facade.findClass("java.lang.Object", method2.getResolveScope());
                weakestClasses.remove(javaLangObjectClass);
            }
            if (TypeMayBeWeakenedInspection.this.onlyWeakentoInterface) {
                Iterator<PsiClass> iterator = weakestClasses.iterator();
                while (iterator.hasNext()) {
                    PsiClass weakestClass = iterator.next();
                    if (weakestClass.isInterface()) continue;
                    iterator.remove();
                }
            }
            if (weakestClasses.isEmpty()) {
                return;
            }
            this.registerMethodError(method2, method2, weakestClasses);
        }
    }

    private static class TypeMayBeWeakenedFix
    extends InspectionGadgetsFix {
        private final String fqClassName;

        TypeMayBeWeakenedFix(@NotNull String fqClassName) {
            this.fqClassName = fqClassName;
        }

        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("type.may.be.weakened.quickfix", this.fqClassName);
        }

        @NotNull
        public String getFamilyName() {
            return "Weaken type";
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) {
            PsiTypeParameter[] typeParameters;
            PsiTypeElement typeElement;
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (parent instanceof PsiVariable) {
                PsiVariable variable = (PsiVariable)parent;
                typeElement = variable.getTypeElement();
            } else if (parent instanceof PsiMethod) {
                PsiMethod method2 = (PsiMethod)parent;
                typeElement = method2.getReturnTypeElement();
            } else {
                return;
            }
            if (typeElement == null) {
                return;
            }
            PsiJavaCodeReferenceElement componentReferenceElement = typeElement.getInnermostComponentReferenceElement();
            if (componentReferenceElement == null) {
                return;
            }
            PsiType oldType = typeElement.getType();
            if (!(oldType instanceof PsiClassType)) {
                return;
            }
            PsiClassType oldClassType = (PsiClassType)oldType;
            PsiType[] parameterTypes = oldClassType.getParameters();
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project2);
            PsiElementFactory factory = facade.getElementFactory();
            PsiType type2 = factory.createTypeFromText(this.fqClassName, element);
            if (!(type2 instanceof PsiClassType)) {
                return;
            }
            PsiClassType classType = (PsiClassType)type2;
            PsiClass aClass = classType.resolve();
            if (aClass != null && (typeParameters = aClass.getTypeParameters()).length != 0 && typeParameters.length == parameterTypes.length) {
                HashMap<PsiTypeParameter, PsiType> typeParameterMap = new HashMap<PsiTypeParameter, PsiType>();
                for (int i2 = 0; i2 < typeParameters.length; ++i2) {
                    PsiTypeParameter typeParameter = typeParameters[i2];
                    PsiType parameterType = parameterTypes[i2];
                    typeParameterMap.put(typeParameter, parameterType);
                }
                PsiSubstitutor substitutor = factory.createSubstitutor(typeParameterMap);
                classType = factory.createType(aClass, substitutor);
            }
            PsiJavaCodeReferenceElement referenceElement = factory.createReferenceElementByType(classType);
            PsiElement replacement = componentReferenceElement.replace((PsiElement)referenceElement);
            JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)project2);
            javaCodeStyleManager.shortenClassReferences(replacement);
        }
    }
}

