/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.asserttoif;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssertionCanBeIfInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("assertion.can.be.if.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return this.getDisplayName();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AssertToIfVisitor();
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new AssertToIfFix();
    }

    private static void doFixImpl(@NotNull PsiElement element) {
        PsiAssertStatement assertStatement = (PsiAssertStatement)element;
        StringBuilder newStatement = new StringBuilder();
        PsiExpression condition2 = assertStatement.getAssertCondition();
        newStatement.append("if(").append(BoolUtils.getNegatedExpressionText(condition2)).append(") throw new java.lang.AssertionError(");
        PsiExpression description = assertStatement.getAssertDescription();
        if (description != null) {
            newStatement.append(description.getText());
        }
        newStatement.append(");");
        PsiReplacementUtil.replaceStatement((PsiStatement)assertStatement, newStatement.toString());
    }

    private static class AssertToIfFix
    extends InspectionGadgetsFix {
        private AssertToIfFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("assert.can.be.if.quickfix", new Object[0]);
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) {
            AssertionCanBeIfInspection.doFixImpl(descriptor.getPsiElement());
        }
    }

    private static class AssertToIfVisitor
    extends BaseInspectionVisitor {
        private AssertToIfVisitor() {
        }

        public void visitAssertStatement(PsiAssertStatement assertStatement) {
            super.visitAssertStatement(assertStatement);
            if (assertStatement.getAssertCondition() != null) {
                this.registerError((PsiElement)assertStatement, new Object[0]);
            }
        }
    }
}

