/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.asserttoif;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThrowStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IfCanBeAssertionInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("if.can.be.assertion.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return this.getDisplayName();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new IfToAssertionVisitor();
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new IfToAssertionFix();
    }

    private static void doFixImpl(@NotNull PsiElement element) {
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiIfStatement)) {
            return;
        }
        PsiIfStatement ifStatement = (PsiIfStatement)parent;
        PsiExpression condition2 = ifStatement.getCondition();
        StringBuilder newStatementText = new StringBuilder("assert ");
        newStatementText.append(BoolUtils.getNegatedExpressionText(condition2));
        PsiNewExpression newException = IfCanBeAssertionInspection.getThrownNewException(ifStatement);
        String message2 = IfCanBeAssertionInspection.getExceptionMessage(newException);
        if (message2 != null) {
            newStatementText.append(':').append(message2);
        }
        newStatementText.append(';');
        PsiReplacementUtil.replaceStatement((PsiStatement)ifStatement, newStatementText.toString());
    }

    private static String getExceptionMessage(PsiNewExpression newExpression) {
        PsiExpression[] arguments;
        PsiExpressionList argumentList;
        if (newExpression != null && (argumentList = newExpression.getArgumentList()) != null && (arguments = argumentList.getExpressions()).length >= 1) {
            return arguments[0].getText();
        }
        return null;
    }

    private static PsiNewExpression getThrownNewException(PsiIfStatement ifStatement) {
        if (ifStatement.getElseBranch() == null) {
            PsiStatement thenBranch = ifStatement.getThenBranch();
            return IfCanBeAssertionInspection.getThrownNewExceptionImpl((PsiElement)thenBranch);
        }
        return null;
    }

    private static PsiNewExpression getThrownNewExceptionImpl(PsiElement element) {
        PsiThrowStatement throwStatement;
        PsiExpression exception;
        if (element instanceof PsiBlockStatement) {
            PsiStatement[] statements = ((PsiBlockStatement)element).getCodeBlock().getStatements();
            if (statements.length == 1) {
                return IfCanBeAssertionInspection.getThrownNewExceptionImpl((PsiElement)statements[0]);
            }
        } else if (element instanceof PsiThrowStatement && (exception = ParenthesesUtils.stripParentheses((throwStatement = (PsiThrowStatement)element).getException())) instanceof PsiNewExpression) {
            return (PsiNewExpression)exception;
        }
        return null;
    }

    private static class IfToAssertionFix
    extends InspectionGadgetsFix {
        private IfToAssertionFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("if.can.be.assertion.quickfix", new Object[0]);
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) {
            IfCanBeAssertionInspection.doFixImpl(descriptor.getPsiElement());
        }
    }

    private static class IfToAssertionVisitor
    extends BaseInspectionVisitor {
        private IfToAssertionVisitor() {
        }

        public void visitKeyword(PsiKeyword keyword) {
            PsiElement parent;
            super.visitKeyword(keyword);
            if (keyword.getTokenType() == JavaTokenType.IF_KEYWORD && (parent = keyword.getParent()) instanceof PsiIfStatement && IfCanBeAssertionInspection.getThrownNewException((PsiIfStatement)parent) != null) {
                this.registerError((PsiElement)keyword, new Object[0]);
            }
        }
    }
}

