/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.assignment;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssignmentToDateFieldFromParameterInspection
extends BaseInspection {
    public boolean ignorePrivateMethods = true;

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("assignment.to.date.calendar.field.from.parameter.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String type2 = (String)infos[0];
        PsiExpression rhs = (PsiExpression)infos[1];
        return InspectionGadgetsBundle.message("assignment.to.date.calendar.field.from.parameter.problem.descriptor", type2, rhs.getText());
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("assignment.collection.array.field.option", new Object[0]), (InspectionProfileEntry)this, "ignorePrivateMethods");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AssignmentToDateFieldFromParameterVisitor();
    }

    private class AssignmentToDateFieldFromParameterVisitor
    extends BaseInspectionVisitor {
        private AssignmentToDateFieldFromParameterVisitor() {
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression2) {
            PsiMethod containingMethod;
            super.visitAssignmentExpression(expression2);
            IElementType tokenType = expression2.getOperationTokenType();
            if (!JavaTokenType.EQ.equals(tokenType)) {
                return;
            }
            PsiExpression lhs = expression2.getLExpression();
            if (!(lhs instanceof PsiReferenceExpression)) {
                return;
            }
            String type2 = TypeUtils.expressionHasTypeOrSubtype(lhs, "java.util.Date", "java.util.Calendar");
            if (type2 == null) {
                return;
            }
            PsiExpression rhs = expression2.getRExpression();
            if (!(rhs instanceof PsiReferenceExpression)) {
                return;
            }
            PsiElement lhsReferent = ((PsiReference)lhs).resolve();
            if (!(lhsReferent instanceof PsiField)) {
                return;
            }
            PsiElement rhsReferent = ((PsiReference)rhs).resolve();
            if (!(rhsReferent instanceof PsiParameter)) {
                return;
            }
            if (!(rhsReferent.getParent() instanceof PsiParameterList)) {
                return;
            }
            if (AssignmentToDateFieldFromParameterInspection.this.ignorePrivateMethods && ((containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiMethod.class)) == null || containingMethod.hasModifierProperty("private"))) {
                return;
            }
            this.registerError((PsiElement)lhs, type2, rhs);
        }
    }
}

