/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.assignment;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiWhileStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import org.jetbrains.annotations.NotNull;

public class AssignmentUsedAsConditionInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("assignment.used.as.condition.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("assignment.used.as.condition.problem.descriptor", new Object[0]);
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new AssignmentUsedAsConditionFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AssignmentUsedAsConditionVisitor();
    }

    private static class AssignmentUsedAsConditionVisitor
    extends BaseInspectionVisitor {
        private AssignmentUsedAsConditionVisitor() {
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression2) {
            PsiExpression condition2;
            super.visitAssignmentExpression(expression2);
            if (expression2.getRExpression() == null || !(expression2.getLExpression() instanceof PsiReferenceExpression)) {
                return;
            }
            PsiElement parent = expression2.getParent();
            if (parent instanceof PsiIfStatement) {
                PsiIfStatement ifStatement = (PsiIfStatement)parent;
                condition2 = ifStatement.getCondition();
            } else if (parent instanceof PsiWhileStatement) {
                PsiWhileStatement whileStatement = (PsiWhileStatement)parent;
                condition2 = whileStatement.getCondition();
            } else if (parent instanceof PsiForStatement) {
                PsiForStatement forStatement = (PsiForStatement)parent;
                condition2 = forStatement.getCondition();
            } else if (parent instanceof PsiDoWhileStatement) {
                PsiDoWhileStatement doWhileStatement = (PsiDoWhileStatement)parent;
                condition2 = doWhileStatement.getCondition();
            } else {
                return;
            }
            if (expression2.equals(condition2)) {
                this.registerError((PsiElement)expression2, new Object[0]);
            }
        }
    }

    private static class AssignmentUsedAsConditionFix
    extends InspectionGadgetsFix {
        private AssignmentUsedAsConditionFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("assignment.used.as.condition.replace.quickfix", new Object[0]);
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) {
            PsiAssignmentExpression expression2 = (PsiAssignmentExpression)descriptor.getPsiElement();
            PsiExpression leftExpression = expression2.getLExpression();
            PsiExpression rightExpression = expression2.getRExpression();
            assert (rightExpression != null);
            String newExpression = leftExpression.getText() + "==" + rightExpression.getText();
            PsiReplacementUtil.replaceExpression((PsiExpression)expression2, newExpression);
        }
    }
}

