/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ComparatorMethodParameterNotUsedInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("comparator.method.parameter.not.used.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("comparator.method.parameter.not.used.problem.descriptor", new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CompareMethodDoesNotUseParameterVisitor();
    }

    private static class CompareMethodDoesNotUseParameterVisitor
    extends BaseInspectionVisitor {
        private CompareMethodDoesNotUseParameterVisitor() {
        }

        public void visitMethod(PsiMethod method2) {
            super.visitMethod(method2);
            if (!MethodUtils.isComparatorCompare(method2) || ControlFlowUtils.methodAlwaysThrowsException(method2)) {
                return;
            }
            this.checkParameterList(method2.getParameterList(), (PsiElement)method2);
        }

        public void visitLambdaExpression(PsiLambdaExpression expression2) {
            super.visitLambdaExpression(expression2);
            PsiClass functionalInterface = PsiUtil.resolveClassInType((PsiType)expression2.getFunctionalInterfaceType());
            if (functionalInterface == null || !"java.util.Comparator".equals(functionalInterface.getQualifiedName()) || ControlFlowUtils.lambdaExpressionAlwaysThrowsException(expression2)) {
                return;
            }
            this.checkParameterList(expression2.getParameterList(), (PsiElement)expression2);
        }

        private void checkParameterList(PsiParameterList parameterList, PsiElement context) {
            ParameterAccessVisitor visitor = new ParameterAccessVisitor(parameterList.getParameters());
            context.accept((PsiElementVisitor)visitor);
            for (PsiParameter unusedParameter : visitor.getUnusedParameters()) {
                this.registerVariableError((PsiVariable)unusedParameter, new Object[0]);
            }
        }

        private static class ParameterAccessVisitor
        extends JavaRecursiveElementWalkingVisitor {
            private final Set<PsiParameter> parameters;

            private ParameterAccessVisitor(@NotNull PsiParameter[] parameters2) {
                this.parameters = new HashSet<PsiParameter>(Arrays.asList(parameters2));
            }

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                super.visitReferenceExpression(expression2);
                if (this.parameters.isEmpty()) {
                    return;
                }
                if (expression2.getQualifierExpression() != null) {
                    return;
                }
                PsiElement target = expression2.resolve();
                if (!(target instanceof PsiParameter)) {
                    return;
                }
                PsiParameter parameter = (PsiParameter)target;
                this.parameters.remove(parameter);
            }

            private Collection<PsiParameter> getUnusedParameters() {
                return Collections.unmodifiableSet(this.parameters);
            }
        }
    }
}

