/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.bugs.NonFinalFieldsVisitor;
import com.siyeh.ig.fixes.MakeFieldFinalFix;
import com.siyeh.ig.psiutils.MethodUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HashCodeUsesNonFinalVariableInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "NonFinalFieldReferencedInHashCode";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("non.final.field.in.hashcode.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("non.final.field.in.hashcode.problem.descriptor", new Object[0]);
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiField field = (PsiField)infos[0];
        return MakeFieldFinalFix.buildFix(field);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new HashCodeUsesNonFinalVariableVisitor();
    }

    private static class HashCodeUsesNonFinalVariableVisitor
    extends NonFinalFieldsVisitor {
        private HashCodeUsesNonFinalVariableVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method2) {
            if (MethodUtils.isHashCode(method2)) {
                this.checkUsedNonFinalFields(method2);
            }
        }
    }
}

