/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.RecursionUtils;
import org.jetbrains.annotations.NotNull;

public class InfiniteRecursionInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("infinite.recursion.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("infinite.recursion.problem.descriptor", new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new InfiniteRecursionVisitor();
    }

    private static class InfiniteRecursionVisitor
    extends BaseInspectionVisitor {
        private InfiniteRecursionVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method2) {
            super.visitMethod(method2);
            if (method2.hasModifierProperty("abstract")) {
                return;
            }
            if (!RecursionUtils.methodMayRecurse(method2)) {
                return;
            }
            if (!RecursionUtils.methodDefinitelyRecurses(method2)) {
                return;
            }
            this.registerMethodError(method2, new Object[0]);
        }
    }
}

