/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.InheritanceUtil;
import org.jetbrains.annotations.NotNull;

public class InstanceofIncompatibleInterfaceInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("instanceof.with.incompatible.interface.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("instanceof.with.incompatible.interface.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new InstanceofIncompatibleInterfaceVisitor();
    }

    private static class InstanceofIncompatibleInterfaceVisitor
    extends BaseInspectionVisitor {
        private InstanceofIncompatibleInterfaceVisitor() {
        }

        public void visitInstanceOfExpression(@NotNull PsiInstanceOfExpression expression2) {
            super.visitInstanceOfExpression(expression2);
            PsiTypeElement castTypeElement = expression2.getCheckType();
            if (castTypeElement == null) {
                return;
            }
            PsiType castType = castTypeElement.getType();
            if (!(castType instanceof PsiClassType)) {
                return;
            }
            PsiClassType castClassType = (PsiClassType)castType;
            PsiExpression operand2 = expression2.getOperand();
            PsiType operandType = operand2.getType();
            if (!(operandType instanceof PsiClassType)) {
                return;
            }
            PsiClassType operandClassType = (PsiClassType)operandType;
            PsiClass castClass = castClassType.resolve();
            if (castClass == null || !castClass.isInterface()) {
                return;
            }
            PsiClass operandClass = operandClassType.resolve();
            if (operandClass == null || operandClass.isInterface()) {
                return;
            }
            if (InheritanceUtil.existsMutualSubclass(operandClass, castClass, this.isOnTheFly())) {
                return;
            }
            this.registerError((PsiElement)castTypeElement, new Object[0]);
        }
    }
}

