/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.IteratorUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class IteratorNextDoesNotThrowNoSuchElementExceptionInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "IteratorNextCanNotThrowNoSuchElementException";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("iterator.next.does.not.throw.nosuchelementexception.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("iterator.next.does.not.throw.nosuchelementexception.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new IteratorNextDoesNotThrowNoSuchElementExceptionVisitor();
    }

    private static class CalledMethodsVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean noSuchElementExceptionThrown;

        private CalledMethodsVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            if (this.noSuchElementExceptionThrown) {
                return;
            }
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            PsiElement method2 = methodExpression.resolve();
            if (method2 == null) {
                return;
            }
            List<PsiClassType> exceptions = ExceptionUtil.getThrownExceptions(method2);
            for (PsiType psiType : exceptions) {
                if (!psiType.equalsToText("java.util.NoSuchElementException")) continue;
                this.noSuchElementExceptionThrown = true;
            }
        }

        boolean isNoSuchElementExceptionThrown() {
            return this.noSuchElementExceptionThrown;
        }
    }

    private static class IteratorNextDoesNotThrowNoSuchElementExceptionVisitor
    extends BaseInspectionVisitor {
        private IteratorNextDoesNotThrowNoSuchElementExceptionVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method2) {
            if (!MethodUtils.methodMatches(method2, "java.util.Iterator", null, "next", new PsiType[0])) {
                return;
            }
            for (PsiType psiType : ExceptionUtil.getThrownExceptions((PsiElement)method2)) {
                if (!psiType.equalsToText("java.util.NoSuchElementException")) continue;
                return;
            }
            if (IteratorUtils.containsCallToIteratorNext((PsiElement)method2, null, false)) {
                return;
            }
            CalledMethodsVisitor visitor = new CalledMethodsVisitor();
            method2.accept((PsiElementVisitor)visitor);
            if (visitor.isNoSuchElementExceptionThrown()) {
                return;
            }
            this.registerMethodError(method2, new Object[0]);
        }
    }
}

