/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.ConstantExpressionUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.bugs.FormatDecode;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.FormatUtils;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class MalformedFormatStringInspectionBase
extends BaseInspection {
    @NonNls
    public String additionalClasses = "";
    @NonNls
    public String additionalMethods = "";
    final List<String> classNames = new ArrayList<String>();
    final List<String> methodNames = new ArrayList<String>();

    public MalformedFormatStringInspectionBase() {
        MalformedFormatStringInspectionBase.parseString(this.additionalClasses, this.classNames);
        MalformedFormatStringInspectionBase.parseString(this.additionalMethods, this.methodNames);
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        super.readSettings(node);
        MalformedFormatStringInspectionBase.parseString(this.additionalClasses, this.classNames);
        MalformedFormatStringInspectionBase.parseString(this.additionalMethods, this.methodNames);
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        this.additionalClasses = MalformedFormatStringInspectionBase.formatString(this.classNames);
        this.additionalMethods = MalformedFormatStringInspectionBase.formatString(this.methodNames);
        super.writeSettings(node);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("malformed.format.string.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Object value2 = infos[0];
        if (value2 instanceof Exception) {
            Exception exception = (Exception)value2;
            String message2 = exception.getMessage();
            if (message2 != null) {
                return InspectionGadgetsBundle.message("malformed.format.string.problem.descriptor.illegal", message2);
            }
            return InspectionGadgetsBundle.message("malformed.format.string.problem.descriptor.malformed", new Object[0]);
        }
        FormatDecode.Validator[] validators = (FormatDecode.Validator[])value2;
        int argumentCount = (Integer)infos[1];
        if (validators.length < argumentCount) {
            return InspectionGadgetsBundle.message("malformed.format.string.problem.descriptor.too.many.arguments", argumentCount, validators.length);
        }
        if (validators.length > argumentCount) {
            return InspectionGadgetsBundle.message("malformed.format.string.problem.descriptor.too.few.arguments", argumentCount, validators.length);
        }
        PsiType argumentType = (PsiType)infos[2];
        FormatDecode.Validator validator = (FormatDecode.Validator)infos[3];
        return InspectionGadgetsBundle.message("malformed.format.string.problem.descriptor.arguments.do.not.match.type", argumentType.getPresentableText(), validator.getSpecifier());
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MalformedFormatStringVisitor();
    }

    private class MalformedFormatStringVisitor
    extends BaseInspectionVisitor {
        private MalformedFormatStringVisitor() {
        }

        private int findFirstStringArgumentIndex(PsiExpression[] expressions2) {
            int length = expressions2.length;
            for (int i2 = 0; i2 < length; ++i2) {
                PsiExpression expression2 = expressions2[i2];
                if (!ExpressionUtils.hasStringType(expression2)) continue;
                return i2;
            }
            return -1;
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            FormatDecode.Validator[] validators;
            super.visitMethodCallExpression(expression2);
            if (!FormatUtils.isFormatCall(expression2, MalformedFormatStringInspectionBase.this.methodNames, MalformedFormatStringInspectionBase.this.classNames)) {
                return;
            }
            PsiExpressionList argumentList = expression2.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            int formatArgumentIndex = this.findFirstStringArgumentIndex(arguments);
            if (formatArgumentIndex < 0) {
                return;
            }
            PsiExpression formatArgument = arguments[formatArgumentIndex];
            if (!ExpressionUtils.hasStringType(formatArgument) || !PsiUtil.isConstantExpression((PsiExpression)formatArgument)) {
                return;
            }
            PsiType formatType = formatArgument.getType();
            if (formatType == null) {
                return;
            }
            String value2 = (String)ConstantExpressionUtil.computeCastTo((PsiExpression)formatArgument, (PsiType)formatType);
            if (value2 == null) {
                return;
            }
            int argumentCount = arguments.length - (formatArgumentIndex + 1);
            try {
                validators = FormatDecode.decode(value2, argumentCount);
            }
            catch (FormatDecode.IllegalFormatException e) {
                this.registerError((PsiElement)formatArgument, e);
                return;
            }
            if (validators.length != argumentCount) {
                PsiExpression argument;
                PsiType argumentType;
                if (argumentCount == 1 && (argumentType = (argument = arguments[formatArgumentIndex + 1]).getType()) instanceof PsiArrayType) {
                    return;
                }
                this.registerMethodCallError(expression2, validators, argumentCount);
                return;
            }
            for (int i2 = 0; i2 < validators.length; ++i2) {
                FormatDecode.Validator validator = validators[i2];
                PsiExpression argument = arguments[i2 + formatArgumentIndex + 1];
                PsiType argumentType = argument.getType();
                if (argumentType == null || validator == null || validator.valid(argumentType)) continue;
                this.registerError((PsiElement)argument, validators, argumentCount, argumentType, validator);
                return;
            }
        }
    }
}

