/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiElementProcessorAdapter;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.EqualityToEqualsFix;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.Collection;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObjectEqualityInspection
extends BaseInspection {
    public boolean m_ignoreEnums = true;
    public boolean m_ignoreClassObjects = false;
    public boolean m_ignorePrivateConstructors = false;

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("object.comparison.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("object.comparison.problem.description", new Object[0]);
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("object.comparison.enumerated.ignore.option", new Object[0]), "m_ignoreEnums");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("object.comparison.klass.ignore.option", new Object[0]), "m_ignoreClassObjects");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("object.equality.ignore.between.objects.of.a.type.with.only.private.constructors.option", new Object[0]), "m_ignorePrivateConstructors");
        return optionsPanel;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ObjectEqualityVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new EqualityToEqualsFix();
    }

    private class ObjectEqualityVisitor
    extends BaseInspectionVisitor {
        private ObjectEqualityVisitor() {
        }

        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression2) {
            super.visitBinaryExpression(expression2);
            if (!ComparisonUtils.isEqualityComparison((PsiExpression)expression2)) {
                return;
            }
            PsiExpression rhs = expression2.getROperand();
            if (!this.isObjectType(rhs)) {
                return;
            }
            PsiExpression lhs = expression2.getLOperand();
            if (!this.isObjectType(lhs)) {
                return;
            }
            if (ObjectEqualityInspection.this.m_ignoreEnums && (this.isEnumType(rhs) || this.isEnumType(lhs))) {
                return;
            }
            if (ObjectEqualityInspection.this.m_ignoreClassObjects && (this.isClass(rhs) || this.isClass(lhs))) {
                return;
            }
            if (ObjectEqualityInspection.this.m_ignorePrivateConstructors && (this.typeHasPrivateConstructor(lhs) || this.typeHasPrivateConstructor(rhs))) {
                return;
            }
            PsiMethod method2 = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiMethod.class);
            if (method2 != null && MethodUtils.isEquals(method2)) {
                return;
            }
            PsiJavaToken sign = expression2.getOperationSign();
            this.registerError((PsiElement)sign, new Object[0]);
        }

        private boolean typeHasPrivateConstructor(@Nullable PsiExpression expression2) {
            if (expression2 == null) {
                return false;
            }
            PsiType type2 = expression2.getType();
            if (!(type2 instanceof PsiClassType)) {
                return false;
            }
            PsiClassType classType = (PsiClassType)type2;
            PsiClass aClass = classType.resolve();
            if (aClass != null && aClass.isInterface()) {
                return this.implementersHaveOnlyPrivateConstructors(aClass);
            }
            return this.hasOnlyPrivateConstructors(aClass);
        }

        private boolean implementersHaveOnlyPrivateConstructors(PsiClass aClass) {
            GlobalSearchScope scope = GlobalSearchScope.allScope((Project)aClass.getProject());
            PsiElementProcessor.CollectElementsWithLimit processor2 = new PsiElementProcessor.CollectElementsWithLimit(6);
            ProgressManager progressManager = ProgressManager.getInstance();
            progressManager.runProcess(() -> ClassInheritorsSearch.search((PsiClass)aClass, (SearchScope)scope, (boolean)true).forEach((Processor)new PsiElementProcessorAdapter((PsiElementProcessor)processor2)), null);
            if (processor2.isOverflow()) {
                return false;
            }
            Collection implementers = processor2.getCollection();
            for (PsiClass implementer : implementers) {
                if (implementer.isInterface() || implementer.hasModifierProperty("abstract") || this.hasOnlyPrivateConstructors(implementer)) continue;
                return false;
            }
            return true;
        }

        private boolean hasOnlyPrivateConstructors(PsiClass aClass) {
            if (aClass == null) {
                return false;
            }
            PsiMethod[] constructors = aClass.getConstructors();
            if (constructors.length == 0) {
                return false;
            }
            for (PsiMethod constructor : constructors) {
                if (constructor.hasModifierProperty("private")) continue;
                return false;
            }
            return true;
        }

        private boolean isClass(@Nullable PsiExpression expression2) {
            if (expression2 == null) {
                return false;
            }
            if (expression2 instanceof PsiClassObjectAccessExpression) {
                return true;
            }
            PsiType type2 = expression2.getType();
            if (!(type2 instanceof PsiClassType)) {
                return false;
            }
            PsiClassType classType = (PsiClassType)type2;
            PsiClassType rawType = classType.rawType();
            return rawType.equalsToText("java.lang.Class");
        }

        private boolean isEnumType(@Nullable PsiExpression expression2) {
            return expression2 != null && TypeUtils.expressionHasTypeOrSubtype(expression2, "java.lang.Enum");
        }

        private boolean isObjectType(PsiExpression expression2) {
            if (expression2 == null) {
                return false;
            }
            PsiType type2 = expression2.getType();
            return type2 != null && !(type2 instanceof PsiArrayType) && !(type2 instanceof PsiPrimitiveType) && !TypeUtils.isJavaLangString(type2) && !TypeUtils.expressionHasTypeOrSubtype(expression2, "java.lang.Number");
        }
    }
}

