/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.AddTypeCastFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.DelegatingFix;
import com.siyeh.ig.InspectionGadgetsFix;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrimitiveArrayArgumentToVariableArgMethodInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "PrimitiveArrayArgumentToVarargsMethod";
    }

    @Nullable
    public String getAlternativeID() {
        return "PrimitiveArrayArgumentToVariableArgMethod";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("primitive.array.argument.to.var.arg.method.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("primitive.array.argument.to.var.arg.method.problem.descriptor", new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public boolean shouldInspect(PsiFile file2) {
        return PsiUtil.isLanguageLevel5OrHigher((PsiElement)file2);
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiExpression argument = (PsiExpression)infos[0];
        PsiType type2 = (PsiType)infos[1];
        return new DelegatingFix((LocalQuickFix)new AddTypeCastFix(type2, argument));
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PrimitiveArrayArgumentToVariableArgVisitor();
    }

    private static boolean isPrimitiveArrayType(PsiType type2) {
        if (!(type2 instanceof PsiArrayType)) {
            return false;
        }
        PsiType componentType = ((PsiArrayType)type2).getComponentType();
        return TypeConversionUtil.isPrimitiveAndNotNull((PsiType)componentType);
    }

    private static boolean isDeepPrimitiveArrayType(PsiType type2, PsiSubstitutor substitutor) {
        if (!(type2 instanceof PsiEllipsisType)) {
            return false;
        }
        PsiType componentType = type2.getDeepComponentType();
        PsiType substitute = substitutor.substitute(componentType);
        return TypeConversionUtil.isPrimitiveAndNotNull((PsiType)substitute.getDeepComponentType());
    }

    private static class PrimitiveArrayArgumentToVariableArgVisitor
    extends BaseInspectionVisitor {
        private PrimitiveArrayArgumentToVariableArgVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
            super.visitMethodCallExpression(call);
            PsiExpressionList argumentList = call.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length == 0) {
                return;
            }
            PsiExpression lastArgument = arguments[arguments.length - 1];
            PsiType argumentType = lastArgument.getType();
            if (!PrimitiveArrayArgumentToVariableArgMethodInspection.isPrimitiveArrayType(argumentType)) {
                return;
            }
            JavaResolveResult result2 = call.resolveMethodGenerics();
            PsiMethod method2 = (PsiMethod)result2.getElement();
            if (method2 == null || AnnotationUtil.isAnnotated((PsiModifierListOwner)method2, Arrays.asList("java.lang.invoke.MethodHandle.PolymorphicSignature"))) {
                return;
            }
            PsiParameterList parameterList = method2.getParameterList();
            if (parameterList.getParametersCount() != arguments.length) {
                return;
            }
            PsiParameter[] parameters2 = parameterList.getParameters();
            PsiParameter lastParameter = parameters2[parameters2.length - 1];
            if (!lastParameter.isVarArgs()) {
                return;
            }
            PsiEllipsisType parameterType = (PsiEllipsisType)lastParameter.getType();
            if (PrimitiveArrayArgumentToVariableArgMethodInspection.isDeepPrimitiveArrayType((PsiType)parameterType, result2.getSubstitutor())) {
                return;
            }
            this.registerError((PsiElement)lastArgument, lastArgument, parameterType.getComponentType());
        }
    }
}

