/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiNewExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class ResultOfObjectAllocationIgnoredInspectionBase
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("result.of.object.allocation.ignored.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("result.of.object.allocation.ignored.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ResultOfObjectAllocationIgnoredVisitor();
    }

    private static class ResultOfObjectAllocationIgnoredVisitor
    extends BaseInspectionVisitor {
        private ResultOfObjectAllocationIgnoredVisitor() {
        }

        public void visitExpressionStatement(@NotNull PsiExpressionStatement statement2) {
            super.visitExpressionStatement(statement2);
            PsiExpression expression2 = statement2.getExpression();
            if (!(expression2 instanceof PsiNewExpression)) {
                return;
            }
            PsiNewExpression newExpression = (PsiNewExpression)expression2;
            PsiExpression[] arrayDimensions = newExpression.getArrayDimensions();
            if (arrayDimensions.length != 0) {
                return;
            }
            if (newExpression.getArrayInitializer() != null) {
                return;
            }
            this.registerNewExpressionError(newExpression, newExpression);
        }
    }
}

