/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.FormatUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class StringConcatenationInFormatCallInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("string.concatenation.in.format.call.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("string.concatenation.in.format.call.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StringConcatenationInFormatCallVisitor();
    }

    private static class StringConcatenationInFormatCallVisitor
    extends BaseInspectionVisitor {
        private StringConcatenationInFormatCallVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            PsiExpression operand2;
            super.visitMethodCallExpression(expression2);
            if (!FormatUtils.isFormatCall(expression2)) {
                return;
            }
            PsiExpressionList argumentList = expression2.getArgumentList();
            PsiExpression formatArgument = FormatUtils.getFormatArgument(argumentList);
            if (!ExpressionUtils.hasStringType(formatArgument)) {
                return;
            }
            if (!(formatArgument instanceof PsiPolyadicExpression)) {
                return;
            }
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)formatArgument;
            PsiExpression[] operands2 = polyadicExpression.getOperands();
            int count = 0;
            PsiExpression[] psiExpressionArray = operands2;
            int n = psiExpressionArray.length;
            for (int j = 0; !(j >= n || (operand2 = psiExpressionArray[j]) instanceof PsiReferenceExpression && ++count > 1); ++j) {
            }
            if (count == 0) {
                return;
            }
            this.registerMethodCallError(expression2, new Object[0]);
        }
    }
}

