/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class SuspiciousIndentAfterControlStatementInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("suspicious.indent.after.control.statement.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("suspicious.indent.after.control.statement.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SuspiciousIndentAfterControlStatementVisitor();
    }

    private static class SuspiciousIndentAfterControlStatementVisitor
    extends BaseInspectionVisitor {
        private SuspiciousIndentAfterControlStatementVisitor() {
        }

        public void visitWhileStatement(PsiWhileStatement statement2) {
            super.visitWhileStatement(statement2);
            this.checkLoopStatement((PsiLoopStatement)statement2);
        }

        public void visitDoWhileStatement(PsiDoWhileStatement statement2) {
            super.visitDoWhileStatement(statement2);
            this.checkLoopStatement((PsiLoopStatement)statement2);
        }

        public void visitForeachStatement(PsiForeachStatement statement2) {
            super.visitForeachStatement(statement2);
            this.checkLoopStatement((PsiLoopStatement)statement2);
        }

        public void visitForStatement(PsiForStatement statement2) {
            super.visitForStatement(statement2);
            this.checkLoopStatement((PsiLoopStatement)statement2);
        }

        public void visitIfStatement(PsiIfStatement statement2) {
            PsiStatement nextStatement;
            super.visitIfStatement(statement2);
            PsiStatement elseStatement = statement2.getElseBranch();
            if (elseStatement instanceof PsiBlockStatement) {
                return;
            }
            if (elseStatement == null) {
                PsiStatement thenStatement = statement2.getThenBranch();
                if (thenStatement instanceof PsiBlockStatement) {
                    return;
                }
                if (thenStatement != null && !SuspiciousIndentAfterControlStatementVisitor.isWhitespaceSuspicious((PsiStatement)statement2, thenStatement)) {
                    return;
                }
            } else if (!SuspiciousIndentAfterControlStatementVisitor.isWhitespaceSuspicious((PsiStatement)statement2, elseStatement)) {
                return;
            }
            if ((nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)statement2, PsiStatement.class)) == null) {
                return;
            }
            this.registerStatementError(nextStatement, new Object[0]);
        }

        private void checkLoopStatement(PsiLoopStatement statement2) {
            PsiStatement body2 = statement2.getBody();
            if (body2 instanceof PsiBlockStatement || body2 == null) {
                return;
            }
            if (!SuspiciousIndentAfterControlStatementVisitor.isWhitespaceSuspicious((PsiStatement)statement2, body2)) {
                return;
            }
            PsiStatement nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)statement2, PsiStatement.class);
            if (nextStatement == null) {
                return;
            }
            this.registerStatementError(nextStatement, new Object[0]);
        }

        private static boolean isWhitespaceSuspicious(PsiStatement statement2, PsiStatement body2) {
            PsiStatement nextStatement;
            boolean lineBreakBeforeBody;
            PsiElement prevSibling = body2.getPrevSibling();
            if (!(prevSibling instanceof PsiWhiteSpace)) {
                lineBreakBeforeBody = false;
                prevSibling = statement2.getPrevSibling();
                if (!(prevSibling instanceof PsiWhiteSpace)) {
                    return false;
                }
            } else {
                String text = prevSibling.getText();
                int lineBreakIndex = SuspiciousIndentAfterControlStatementVisitor.getLineBreakIndex(text);
                if (lineBreakIndex < 0) {
                    lineBreakBeforeBody = false;
                    prevSibling = statement2.getPrevSibling();
                    if (!(prevSibling instanceof PsiWhiteSpace)) {
                        return false;
                    }
                } else {
                    lineBreakBeforeBody = true;
                }
            }
            if ((nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)statement2, PsiStatement.class)) == null) {
                return false;
            }
            String text = prevSibling.getText();
            int index = SuspiciousIndentAfterControlStatementVisitor.getLineBreakIndex(text);
            if (index < 0) {
                return false;
            }
            String indent = text.substring(index + 1);
            PsiElement nextSibling = nextStatement.getPrevSibling();
            if (!(nextSibling instanceof PsiWhiteSpace)) {
                return false;
            }
            String nextText = nextSibling.getText();
            int nextIndex = SuspiciousIndentAfterControlStatementVisitor.getLineBreakIndex(nextText);
            if (nextIndex < 0) {
                return false;
            }
            String nextIndent = nextText.substring(nextIndex + 1);
            if (lineBreakBeforeBody) {
                return indent.equals(nextIndent);
            }
            return !indent.equals(nextIndent);
        }

        private static int getLineBreakIndex(String text) {
            int newLineIndex1 = text.lastIndexOf(10);
            int carriageReturnIndex1 = text.lastIndexOf(13);
            return Math.max(newLineIndex1, carriageReturnIndex1);
        }
    }
}

