/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class AnonymousInnerClassInspectionBase
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("anonymous.inner.class.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("anonymous.inner.class.problem.descriptor", new Object[0]);
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AnonymousInnerClassVisitor();
    }

    private static class AnonymousInnerClassVisitor
    extends BaseInspectionVisitor {
        private AnonymousInnerClassVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
        }

        public void visitAnonymousClass(@NotNull PsiAnonymousClass aClass) {
            super.visitAnonymousClass(aClass);
            if (aClass instanceof PsiEnumConstantInitializer) {
                return;
            }
            this.registerClassError((PsiClass)aClass, new Object[0]);
        }
    }
}

