/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.util.FileTypeUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class ClassNameDiffersFromFileNameInspectionBase
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("class.name.differs.from.file.name.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("class.name.differs.from.file.name.problem.descriptor", new Object[0]);
    }

    @Override
    public boolean shouldInspect(PsiFile file2) {
        return !FileTypeUtils.isInServerPageFile((PsiElement)file2);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ClassNameDiffersFromFileNameVisitor();
    }

    private static class ClassNameDiffersFromFileNameVisitor
    extends BaseInspectionVisitor {
        private ClassNameDiffersFromFileNameVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            PsiElement parent = aClass.getParent();
            if (!(parent instanceof PsiJavaFile)) {
                return;
            }
            PsiJavaFile file2 = (PsiJavaFile)parent;
            String className = aClass.getName();
            if (className == null) {
                return;
            }
            String fileName = file2.getName();
            int prefixIndex = fileName.indexOf(46);
            if (prefixIndex < 0) {
                return;
            }
            String filenameWithoutPrefix = fileName.substring(0, prefixIndex);
            if (className.equals(filenameWithoutPrefix)) {
                return;
            }
            this.registerClassError(aClass, file2);
        }
    }
}

