/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ListenerMayUseAdapterInspection
extends BaseInspection {
    public boolean checkForEmptyMethods = true;

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("listener.may.use.adapter.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiClass aClass = (PsiClass)infos[0];
        String className = aClass.getName();
        PsiClass adapterClass = (PsiClass)infos[1];
        String adapterName = adapterClass.getName();
        return InspectionGadgetsBundle.message("listener.may.use.adapter.problem.descriptor", className, adapterName);
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("listener.may.use.adapter.emtpy.methods.option", new Object[0]), (InspectionProfileEntry)this, "checkForEmptyMethods");
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiClass adapterClass = (PsiClass)infos[1];
        return new ListenerMayUseAdapterFix(adapterClass);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ListenerMayUseAdapterVisitor();
    }

    private class ListenerMayUseAdapterVisitor
    extends BaseInspectionVisitor {
        private ListenerMayUseAdapterVisitor() {
        }

        public void visitClass(PsiClass aClass) {
            PsiJavaCodeReferenceElement[] implementsReferences;
            PsiReferenceList extendsList = aClass.getExtendsList();
            if (extendsList == null) {
                return;
            }
            PsiJavaCodeReferenceElement[] extendsReferences = extendsList.getReferenceElements();
            if (extendsReferences.length > 0) {
                return;
            }
            PsiReferenceList implementsList = aClass.getImplementsList();
            if (implementsList == null) {
                return;
            }
            for (PsiJavaCodeReferenceElement implementsReference : implementsReferences = implementsList.getReferenceElements()) {
                this.checkReference(aClass, implementsReference);
            }
        }

        private void checkReference(@NotNull PsiClass aClass, @NotNull PsiJavaCodeReferenceElement implementsReference) {
            GlobalSearchScope scope;
            PsiElement target = implementsReference.resolve();
            if (!(target instanceof PsiClass)) {
                return;
            }
            PsiClass implementsClass = (PsiClass)target;
            String className = implementsClass.getQualifiedName();
            if (className == null || !className.endsWith("Listener")) {
                return;
            }
            String adapterName = className.substring(0, className.length() - 8) + "Adapter";
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)aClass.getProject());
            PsiClass adapterClass = psiFacade.findClass(adapterName, scope = implementsClass.getResolveScope());
            if (adapterClass == null) {
                return;
            }
            if (aClass.equals(adapterClass)) {
                return;
            }
            if (!adapterClass.hasModifierProperty("abstract")) {
                return;
            }
            PsiReferenceList implementsList = adapterClass.getImplementsList();
            if (implementsList == null) {
                return;
            }
            PsiJavaCodeReferenceElement[] referenceElements = implementsList.getReferenceElements();
            boolean adapterImplementsListener = false;
            for (PsiJavaCodeReferenceElement referenceElement : referenceElements) {
                PsiElement implementsTarget = referenceElement.resolve();
                if (!implementsClass.equals(implementsTarget)) continue;
                adapterImplementsListener = true;
            }
            if (!adapterImplementsListener) {
                return;
            }
            if (ListenerMayUseAdapterInspection.this.checkForEmptyMethods) {
                PsiMethod[] methods;
                boolean emptyMethodFound = false;
                for (PsiMethod method2 : methods = aClass.getMethods()) {
                    PsiMethod[] superMethods;
                    PsiCodeBlock body2 = method2.getBody();
                    if (!ControlFlowUtils.isEmptyCodeBlock(body2) || (superMethods = method2.findSuperMethods(implementsClass)).length == 0) continue;
                    emptyMethodFound = true;
                    break;
                }
                if (!emptyMethodFound) {
                    return;
                }
            }
            this.registerError((PsiElement)implementsReference, aClass, adapterClass);
        }
    }

    private static class ListenerMayUseAdapterFix
    extends InspectionGadgetsFix {
        private final PsiClass adapterClass;

        ListenerMayUseAdapterFix(@NotNull PsiClass adapterClass) {
            this.adapterClass = adapterClass;
        }

        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("listener.may.use.adapter.quickfix", this.adapterClass.getName());
        }

        @NotNull
        public String getFamilyName() {
            return "Replace with adapter";
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiJavaCodeReferenceElement element = (PsiJavaCodeReferenceElement)descriptor.getPsiElement();
            PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
            if (aClass == null) {
                return;
            }
            PsiReferenceList extendsList = aClass.getExtendsList();
            if (extendsList == null) {
                return;
            }
            PsiMethod[] methods = aClass.getMethods();
            if (methods.length > 0) {
                PsiElement target = element.resolve();
                if (!(target instanceof PsiClass)) {
                    return;
                }
                PsiClass interfaceClass = (PsiClass)target;
                for (PsiMethod method2 : methods) {
                    PsiMethod[] superMethods;
                    if (!ControlFlowUtils.isEmptyCodeBlock(method2.getBody()) || (superMethods = method2.findSuperMethods(interfaceClass)).length <= 0) continue;
                    method2.delete();
                }
            }
            element.delete();
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project2);
            PsiElementFactory elementFactory = psiFacade.getElementFactory();
            PsiJavaCodeReferenceElement referenceElement = elementFactory.createClassReferenceElement(this.adapterClass);
            extendsList.add((PsiElement)referenceElement);
        }
    }
}

