/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaFile;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class MultipleTopLevelClassesInFileInspectionBase
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("multiple.top.level.classes.in.file.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("multiple.top.level.classes.in.file.problem.descriptor", new Object[0]);
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MultipleTopLevelClassesInFileVisitor();
    }

    private static class MultipleTopLevelClassesInFileVisitor
    extends BaseInspectionVisitor {
        private MultipleTopLevelClassesInFileVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            PsiElement[] children2;
            if (!(aClass.getParent() instanceof PsiJavaFile)) {
                return;
            }
            PsiJavaFile file2 = (PsiJavaFile)aClass.getParent();
            if (file2 == null) {
                return;
            }
            int numClasses = 0;
            for (PsiElement child : children2 = file2.getChildren()) {
                if (!(child instanceof PsiClass)) continue;
                ++numClasses;
            }
            if (numClasses <= 1) {
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }
    }
}

