/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.FindSuperElementsHelper;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodUtils;
import org.jetbrains.annotations.NotNull;

public class NoopMethodInAbstractClassInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("noop.method.in.abstract.class.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("noop.method.in.abstract.class.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NoopMethodInAbstractClassVisitor();
    }

    private static class NoopMethodInAbstractClassVisitor
    extends BaseInspectionVisitor {
        private NoopMethodInAbstractClassVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method2) {
            if (method2.isConstructor()) {
                return;
            }
            PsiClass containingClass = method2.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (containingClass.isInterface() || containingClass.isAnnotationType()) {
                return;
            }
            if (!containingClass.hasModifierProperty("abstract")) {
                return;
            }
            if (method2.hasModifierProperty("abstract") || method2.hasModifierProperty("native") || method2.hasModifierProperty("final")) {
                return;
            }
            if (!MethodUtils.isEmpty(method2)) {
                return;
            }
            if (FindSuperElementsHelper.getSiblingInheritedViaSubClass(method2) != null) {
                return;
            }
            this.registerMethodError(method2, new Object[0]);
        }
    }
}

