/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameterList;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RemoveModifierFix;
import com.siyeh.ig.psiutils.SerializationUtils;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class PublicConstructorInNonPublicClassInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("public.constructor.in.non.public.class.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiMethod method2 = (PsiMethod)infos[0];
        return InspectionGadgetsBundle.message("public.constructor.in.non.public.class.problem.descriptor", method2.getName());
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PublicConstructorInNonPublicClassVisitor();
    }

    @Override
    @NotNull
    public InspectionGadgetsFix[] buildFixes(Object ... infos) {
        ArrayList<InspectionGadgetsFix> fixes = new ArrayList<InspectionGadgetsFix>();
        PsiMethod constructor = (PsiMethod)infos[0];
        PsiClass aClass = constructor.getContainingClass();
        if (aClass != null && aClass.hasModifierProperty("private")) {
            fixes.add(new SetConstructorModifierFix("private"));
        }
        fixes.add(new RemoveModifierFix("public"));
        return fixes.toArray(new InspectionGadgetsFix[fixes.size()]);
    }

    private static class PublicConstructorInNonPublicClassVisitor
    extends BaseInspectionVisitor {
        private PublicConstructorInNonPublicClassVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method2) {
            PsiParameterList parameterList;
            if (!method2.isConstructor()) {
                return;
            }
            if (!method2.hasModifierProperty("public")) {
                return;
            }
            PsiClass containingClass = method2.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (containingClass.hasModifierProperty("public") || containingClass.hasModifierProperty("protected")) {
                return;
            }
            if (SerializationUtils.isExternalizable(containingClass) && (parameterList = method2.getParameterList()).getParametersCount() == 0) {
                return;
            }
            this.registerModifierError("public", (PsiModifierListOwner)method2, method2);
        }
    }

    private static class SetConstructorModifierFix
    extends InspectionGadgetsFix {
        @PsiModifier.ModifierConstant
        private final String modifier;

        SetConstructorModifierFix(@PsiModifier.ModifierConstant String modifier) {
            this.modifier = modifier;
        }

        @NotNull
        public String getFamilyName() {
            return "Fix constructor modifier";
        }

        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("public.constructor.in.non.public.class.quickfix", this.modifier);
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            PsiModifierList modifierList = (PsiModifierList)element.getParent();
            modifierList.setModifierProperty("public", false);
            modifierList.setModifierProperty(this.modifier, true);
        }
    }
}

