/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.SerializationUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PublicConstructorInspectionBase
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("public.constructor.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        if (((Boolean)infos[0]).booleanValue()) {
            return InspectionGadgetsBundle.message("public.default.constructor.problem.descriptor", new Object[0]);
        }
        return InspectionGadgetsBundle.message("public.constructor.problem.descriptor", new Object[0]);
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PublicConstructorVisitor();
    }

    private static class PublicConstructorVisitor
    extends BaseInspectionVisitor {
        private PublicConstructorVisitor() {
        }

        public void visitMethod(PsiMethod method2) {
            PsiParameterList parameterList;
            super.visitMethod(method2);
            if (!method2.isConstructor()) {
                return;
            }
            if (!method2.hasModifierProperty("public")) {
                return;
            }
            PsiClass aClass = method2.getContainingClass();
            if (aClass == null || aClass.hasModifierProperty("abstract")) {
                return;
            }
            if (SerializationUtils.isExternalizable(aClass) && (parameterList = method2.getParameterList()).getParametersCount() == 0) {
                return;
            }
            this.registerMethodError(method2, Boolean.FALSE);
        }

        public void visitClass(PsiClass aClass) {
            super.visitClass(aClass);
            if (aClass.isInterface() || aClass.isEnum()) {
                return;
            }
            if (!aClass.hasModifierProperty("public") || aClass.hasModifierProperty("abstract")) {
                return;
            }
            PsiMethod[] constructors = aClass.getConstructors();
            if (constructors.length > 0) {
                return;
            }
            if (SerializationUtils.isExternalizable(aClass)) {
                return;
            }
            this.registerClassError(aClass, Boolean.TRUE);
        }
    }
}

