/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefField;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.siyeh.ig.BaseGlobalInspection;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StaticFieldCanBeMovedToUseInspection
extends BaseGlobalInspection {
    @NotNull
    public String getDisplayName() {
        return null;
    }

    @Nullable
    public CommonProblemDescriptor[] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope analysisScope, @NotNull InspectionManager inspectionManager, @NotNull GlobalInspectionContext globalInspectionContext) {
        if (!(refEntity instanceof RefField)) {
            return null;
        }
        RefField refField = (RefField)refEntity;
        PsiField field = refField.getElement();
        if (field == null) {
            return null;
        }
        PsiType type2 = field.getType();
        if (!type2.equals(PsiType.BOOLEAN)) {
            return null;
        }
        RefClass fieldClass = refField.getOwnerClass();
        Collection inReferences = refField.getInReferences();
        RefJavaUtil refUtil = RefJavaUtil.getInstance();
        HashSet<RefClass> classesUsed = new HashSet<RefClass>();
        for (RefElement inReference : inReferences) {
            RefClass referringClass = refUtil.getOwnerClass(inReference);
            if (referringClass == null) {
                return null;
            }
            if (referringClass.equals(fieldClass)) {
                return null;
            }
            classesUsed.add(referringClass);
            if (classesUsed.size() <= 1) continue;
            return null;
        }
        if (classesUsed.size() != 1) {
            return null;
        }
        RefClass referencingClass = (RefClass)classesUsed.iterator().next();
        String errorString = "Static field " + refEntity.getName() + " is only accessed in subclass " + referencingClass.getName();
        return new CommonProblemDescriptor[]{inspectionManager.createProblemDescriptor(errorString, new QuickFix[0])};
    }
}

